/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xmlsenderws.webservices.utils;

import io.github.project.openubl.xmlsenderws.webservices.catalogs.Catalogo1;
import io.github.project.openubl.xmlsenderws.webservices.models.DeliveryURLType;
import io.github.project.openubl.xmlsenderws.webservices.xml.DocumentType;
import io.github.project.openubl.xmlsenderws.webservices.xml.XmlContentModel;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.regex.Pattern;

public class UBLUtils {
    private static final String FILENAME_FORMAT1 = "{0}-{1}-{2}";
    private static final String FILENAME_FORMAT2 = "{0}-{1}";

    public static Optional<DeliveryURLType> getDeliveryURLType(DocumentType documentType, XmlContentModel xmlContentModel) {
        DeliveryURLType result = null;
        switch (documentType) {
            case INVOICE: 
            case CREDIT_NOTE: 
            case DEBIT_NOTE: 
            case SUMMARY_DOCUMENT: {
                result = DeliveryURLType.BASIC_DOCUMENTS_URL;
                break;
            }
            case VOIDED_DOCUMENT: {
                String tipoDocumentoAfectado = xmlContentModel.getVoidedLineDocumentTypeCode();
                Catalogo1 catalog1 = Catalogo1.valueOfCode(tipoDocumentoAfectado).orElseThrow(() -> new IllegalStateException("No se pudo convertir el valor del cat\u00e1logo"));
                if (catalog1.equals((Object)Catalogo1.PERCEPCION) || catalog1.equals((Object)Catalogo1.RETENCION)) {
                    result = DeliveryURLType.PERCEPTION_RETENTION_URL;
                    break;
                }
                if (catalog1.equals((Object)Catalogo1.GUIA_REMISION_REMITENTE)) {
                    result = DeliveryURLType.DESPATCH_DOCUMENT_URL;
                    break;
                }
                result = DeliveryURLType.BASIC_DOCUMENTS_URL;
                break;
            }
            case PERCEPTION: 
            case RETENTION: {
                result = DeliveryURLType.PERCEPTION_RETENTION_URL;
                break;
            }
            case DESPATCH_ADVICE: {
                result = DeliveryURLType.DESPATCH_DOCUMENT_URL;
            }
        }
        return Optional.ofNullable(result);
    }

    public static Optional<String> getFileNameWithoutExtension(DocumentType type, String ruc, String documentID) {
        String result = null;
        switch (type) {
            case INVOICE: {
                String codigoDocumento;
                if (Pattern.compile("^[F|f].*$").matcher(documentID).find()) {
                    codigoDocumento = Catalogo1.FACTURA.getCode();
                } else if (Pattern.compile("^[B|b].*$").matcher(documentID).find()) {
                    codigoDocumento = Catalogo1.BOLETA.getCode();
                } else {
                    throw new IllegalStateException("Invalid Serie, can not detect code");
                }
                result = MessageFormat.format(FILENAME_FORMAT1, ruc, codigoDocumento, documentID);
                break;
            }
            case CREDIT_NOTE: {
                String codigoDocumento = Catalogo1.NOTA_CREDITO.getCode();
                result = MessageFormat.format(FILENAME_FORMAT1, ruc, codigoDocumento, documentID);
                break;
            }
            case DEBIT_NOTE: {
                String codigoDocumento = Catalogo1.NOTA_DEBITO.getCode();
                result = MessageFormat.format(FILENAME_FORMAT1, ruc, codigoDocumento, documentID);
                break;
            }
            case SUMMARY_DOCUMENT: 
            case VOIDED_DOCUMENT: {
                result = MessageFormat.format(FILENAME_FORMAT2, ruc, documentID);
                break;
            }
            case PERCEPTION: {
                String codigoDocumento = Catalogo1.PERCEPCION.getCode();
                result = MessageFormat.format(FILENAME_FORMAT1, ruc, codigoDocumento, documentID);
                break;
            }
            case RETENTION: {
                String codigoDocumento = Catalogo1.RETENCION.getCode();
                result = MessageFormat.format(FILENAME_FORMAT1, ruc, codigoDocumento, documentID);
                break;
            }
            case DESPATCH_ADVICE: {
                String codigoDocumento = Catalogo1.GUIA_REMISION_REMITENTE.getCode();
                result = MessageFormat.format(FILENAME_FORMAT1, ruc, codigoDocumento, documentID);
            }
        }
        return Optional.ofNullable(result);
    }
}

