/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xmlsenderws.webservices.xml;

import java.util.Optional;
import java.util.stream.Stream;

public enum DocumentType {
    INVOICE("Invoice"),
    CREDIT_NOTE("CreditNote"),
    DEBIT_NOTE("DebitNote"),
    VOIDED_DOCUMENT("VoidedDocuments"),
    SUMMARY_DOCUMENT("SummaryDocuments"),
    PERCEPTION("Perception"),
    RETENTION("Retention"),
    DESPATCH_ADVICE("DespatchAdvice");

    private final String type;

    private DocumentType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static Optional<DocumentType> valueFromDocumentType(String documentType) {
        return Stream.of(DocumentType.values()).filter(p -> p.getType().equals(documentType)).findFirst();
    }
}

