/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xmlsenderws.webservices.managers;

import io.github.project.openubl.xmlsenderws.webservices.providers.BillServiceCallback;
import io.github.project.openubl.xmlsenderws.webservices.providers.BillServiceModel;
import io.github.project.openubl.xmlsenderws.webservices.providers.DefaultBillServiceProvider;
import io.github.project.openubl.xmlsenderws.webservices.wrappers.ServiceConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;

public class BillServiceManager {
    static final long DEFAULT_DELAY = 5000L;

    private BillServiceManager() {
    }

    public static BillServiceModel sendBill(File file, ServiceConfig config) throws IOException {
        return BillServiceManager.sendBill(file.toPath(), config);
    }

    public static BillServiceModel sendBill(Path path, ServiceConfig config) throws IOException {
        return BillServiceManager.sendBill(path.getFileName().toString(), Files.readAllBytes(path), config);
    }

    public static BillServiceModel sendBill(String fileName, byte[] file, ServiceConfig config) {
        DefaultBillServiceProvider billServiceProvider = new DefaultBillServiceProvider();
        return billServiceProvider.sendBill(fileName, file, config);
    }

    public static BillServiceModel getStatus(String ticket, ServiceConfig config) {
        DefaultBillServiceProvider billServiceProvider = new DefaultBillServiceProvider();
        return billServiceProvider.getStatus(ticket, config);
    }

    public static BillServiceModel sendSummary(File file, ServiceConfig config) throws IOException {
        return BillServiceManager.sendSummary(file.toPath(), config);
    }

    public static BillServiceModel sendSummary(File file, ServiceConfig config, Map<String, Object> params, BillServiceCallback callback, long delay) throws IOException {
        return BillServiceManager.sendSummary(file.toPath(), config, params, callback, delay);
    }

    public static BillServiceModel sendSummary(Path path, ServiceConfig config) throws IOException {
        return BillServiceManager.sendSummary(path.getFileName().toString(), Files.readAllBytes(path), config, Collections.emptyMap(), null, -1L);
    }

    public static BillServiceModel sendSummary(Path path, ServiceConfig config, Map<String, Object> params, BillServiceCallback callback, long delay) throws IOException {
        return BillServiceManager.sendSummary(path.getFileName().toString(), Files.readAllBytes(path), config, params, callback, delay);
    }

    public static BillServiceModel sendSummary(String fileName, byte[] file, ServiceConfig config) {
        return BillServiceManager.sendSummary(fileName, file, config, Collections.emptyMap(), null, -1L);
    }

    public static BillServiceModel sendSummary(String fileName, byte[] file, ServiceConfig config, Map<String, Object> params, BillServiceCallback callback, long delay) {
        DefaultBillServiceProvider billServiceProvider = new DefaultBillServiceProvider();
        BillServiceModel result = callback != null ? billServiceProvider.sendSummary(fileName, file, config, params, callback, delay) : billServiceProvider.sendSummary(fileName, file, config);
        return result;
    }

    public static BillServiceModel sendPack(File file, ServiceConfig config) throws IOException {
        return BillServiceManager.sendPack(file.toPath(), config);
    }

    public static BillServiceModel sendPack(Path path, ServiceConfig config) throws IOException {
        return BillServiceManager.sendPack(path.getFileName().toString(), Files.readAllBytes(path), config);
    }

    public static BillServiceModel sendPack(String fileName, byte[] file, ServiceConfig config) {
        DefaultBillServiceProvider billServiceProvider = new DefaultBillServiceProvider();
        return billServiceProvider.sendPack(fileName, file, config);
    }
}

