/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xmlsenderws.webservices.managers.smart;

import io.github.project.openubl.xmlsenderws.webservices.exceptions.InvalidXMLFileException;
import io.github.project.openubl.xmlsenderws.webservices.exceptions.UnsupportedDocumentTypeException;
import io.github.project.openubl.xmlsenderws.webservices.managers.smart.SmartBillServiceConfig;
import io.github.project.openubl.xmlsenderws.webservices.managers.smart.SmartBillServiceModel;
import io.github.project.openubl.xmlsenderws.webservices.managers.smart.custom.CustomBillServiceConfig;
import io.github.project.openubl.xmlsenderws.webservices.managers.smart.custom.CustomSmartBillServiceManager;
import io.github.project.openubl.xmlsenderws.webservices.providers.BillServiceModel;
import io.github.project.openubl.xmlsenderws.webservices.xml.XmlContentModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class SmartBillServiceManager {
    private SmartBillServiceManager() {
    }

    public static SmartBillServiceModel send(File file, String username, String password) throws InvalidXMLFileException, UnsupportedDocumentTypeException, IOException {
        return SmartBillServiceManager.send(file.toPath(), username, password);
    }

    public static SmartBillServiceModel send(Path path, String username, String password) throws InvalidXMLFileException, UnsupportedDocumentTypeException, IOException {
        return SmartBillServiceManager.send(Files.readAllBytes(path), username, password);
    }

    public static SmartBillServiceModel send(byte[] file, String username, String password) throws InvalidXMLFileException, UnsupportedDocumentTypeException {
        SmartBillServiceConfig config = SmartBillServiceConfig.getInstance();
        return CustomSmartBillServiceManager.send(file, username, password, (CustomBillServiceConfig)new BillServiceConfig(config));
    }

    public static BillServiceModel getStatus(String ticket, XmlContentModel xmlContentModel, String username, String password) {
        SmartBillServiceConfig config = SmartBillServiceConfig.getInstance();
        return CustomSmartBillServiceManager.getStatus(ticket, xmlContentModel, username, password, new BillServiceConfig(config));
    }

    public static class BillServiceConfig
    implements CustomBillServiceConfig {
        private final SmartBillServiceConfig config;

        public BillServiceConfig(SmartBillServiceConfig config) {
            this.config = config;
        }

        @Override
        public String getInvoiceAndNoteDeliveryURL() {
            return this.config.getInvoiceAndNoteDeliveryURL();
        }

        @Override
        public String getPerceptionAndRetentionDeliveryURL() {
            return this.config.getPerceptionAndRetentionDeliveryURL();
        }

        @Override
        public String getDespatchAdviceDeliveryURL() {
            return this.config.getDespatchAdviceDeliveryURL();
        }
    }
}

