/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xmlsenderws.webservices.models;

import java.util.Optional;
import java.util.stream.Stream;

public enum GetStatusResponseType {
    EXISTE_Y_ACEPTADO("0001", "El comprobante existe y est\u00e1 aceptado"),
    EXISTE_PERO_RECHAZADO("0002", "El comprobante existe pero est\u00e1 rechazado"),
    EXISTE_PERO_DADO_DE_BAJA("0003", "El comprobante existe pero est\u00e1 de baja"),
    ERROR_CONSULTA1("0004", "Formato de RUC no es v\u00e1lido (debe de contener 11 caracteres num\u00e9ricos)"),
    ERROR_CONSULTA2("0005", "Formato del tipo de comprobante no es v\u00e1lido (debe de contener 2 caracteres)"),
    ERROR_CONSULTA3("0006", "Formato de serie inv\u00e1lido (debe de contener 4 caracteres)"),
    ERROR_CONSULTA4("0007", "El numero de comprobante debe de ser mayor que cero"),
    ERROR_CONSULTA5("0008", "El n\u00famero de RUC no est\u00e1 inscrito en los registros de la SUNAT"),
    ERROR_CONSULTA6("0009", "EL tipo de comprobante debe de ser (01, 07 o 08)"),
    ERROR_CONSULTA7("0010", "S\u00f3lo se puede consultar facturas, notas de cr\u00e9dito y debito electr\u00f3nicas, cuya serie empieza con F"),
    ERROR_CONSULTA8("0011", "El comprobante de pago electr\u00f3nico no existe"),
    ERROR_CONSULTA9("0012", "El comprobante de pago electr\u00f3nico no le pertenece");

    private final String code;
    private final String description;

    private GetStatusResponseType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static Optional<GetStatusResponseType> searchByCode(String code) {
        return Stream.of(GetStatusResponseType.values()).filter(p -> p.getCode().equals(code)).findFirst();
    }
}

