/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xmlsenderws.webservices.providers.errors;

import io.github.project.openubl.xmlsenderws.webservices.providers.AbstractErrorBillServiceProvider;
import io.github.project.openubl.xmlsenderws.webservices.providers.BillServiceModel;
import io.github.project.openubl.xmlsenderws.webservices.utils.SunatErrors;
import io.github.project.openubl.xmlsenderws.webservices.wrappers.ServiceConfig;

public class ErrorRechazoBillServiceProvider
extends AbstractErrorBillServiceProvider {
    private final BillServiceModel previousResult;
    private final Integer exceptionCode;

    public ErrorRechazoBillServiceProvider(Integer exceptionCode) {
        this.previousResult = null;
        this.exceptionCode = exceptionCode;
    }

    public ErrorRechazoBillServiceProvider(BillServiceModel previousResult, Integer exceptionCode) {
        this.previousResult = previousResult;
        this.exceptionCode = exceptionCode;
    }

    @Override
    public BillServiceModel sendBill(String fileName, byte[] file, ServiceConfig config) {
        BillServiceModel result = new BillServiceModel();
        if (this.previousResult == null) {
            String errorMessage = SunatErrors.getInstance().get(this.exceptionCode);
            result.setStatus(BillServiceModel.Status.RECHAZADO);
            result.setCode(this.exceptionCode);
            result.setDescription(errorMessage);
        } else {
            result.setCdr(this.previousResult.getCdr());
            result.setCode(this.previousResult.getCode());
            result.setStatus(this.previousResult.getStatus());
            result.setTicket(this.previousResult.getTicket());
            result.setDescription(this.previousResult.getDescription());
        }
        return result;
    }
}

