/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xsender.camel.routes;

import org.apache.camel.BindToRegistry;
import org.apache.camel.Configuration;
import org.apache.camel.PropertyInject;
import org.apache.camel.component.cxf.jaxws.CxfEndpoint;
import org.apache.cxf.ext.logging.LoggingFeature;
import service.sunat.gob.pe.billservice.BillService;
import service.sunat.gob.pe.billvalidservice.BillValidService;

@Configuration
public class CxfEndpointConfiguration {
    private CxfEndpoint getBasicCxfEndpoint(boolean enableLoggingFeature) {
        LoggingFeature loggingFeature = new LoggingFeature();
        loggingFeature.setPrettyLogging(true);
        CxfEndpoint cxfEndpoint = new CxfEndpoint();
        cxfEndpoint.setDefaultOperationNamespace("http://service.sunat.gob.pe");
        if (enableLoggingFeature) {
            cxfEndpoint.getFeatures().add(loggingFeature);
        }
        return cxfEndpoint;
    }

    @BindToRegistry(value="cxfBillServiceEndpoint")
    public CxfEndpoint cxfBillServiceEndpoint(@PropertyInject(value="enableLoggingFeature") boolean enableLoggingFeature) {
        CxfEndpoint cxfEndpoint = this.getBasicCxfEndpoint(enableLoggingFeature);
        cxfEndpoint.setAddress("https://e-factura.sunat.gob.pe/ol-ti-itcpfegem/billService");
        cxfEndpoint.setServiceClass(BillService.class);
        cxfEndpoint.setServiceName("billService");
        cxfEndpoint.setWsdlURL("wsdl/billService.wsdl");
        return cxfEndpoint;
    }

    @BindToRegistry(value="cxfBillConsultServiceEndpoint")
    public CxfEndpoint cxfBillConsultServiceEndpoint(@PropertyInject(value="enableLoggingFeature") boolean enableLoggingFeature) {
        CxfEndpoint cxfEndpoint = this.getBasicCxfEndpoint(enableLoggingFeature);
        cxfEndpoint.setAddress("https://e-factura.sunat.gob.pe/ol-it-wsconscpegem/billConsultService");
        cxfEndpoint.setServiceClass(service.sunat.gob.pe.billconsultservice.BillService.class);
        cxfEndpoint.setWsdlURL("wsdl/billConsultService.wsdl");
        return cxfEndpoint;
    }

    @BindToRegistry(value="cxfBillValidServiceEndpoint")
    public CxfEndpoint cxfBillValidServiceEndpoint(@PropertyInject(value="enableLoggingFeature") boolean enableLoggingFeature) {
        CxfEndpoint cxfEndpoint = this.getBasicCxfEndpoint(enableLoggingFeature);
        cxfEndpoint.setAddress("https://e-factura.sunat.gob.pe/ol-it-wsconsvalidcpe/billValidService");
        cxfEndpoint.setServiceClass(BillValidService.class);
        cxfEndpoint.setWsdlURL("wsdl/billValidService.wsdl");
        return cxfEndpoint;
    }
}

