/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xsender.camel.routes;

import io.github.project.openubl.xsender.models.Metadata;
import io.github.project.openubl.xsender.models.Status;
import io.github.project.openubl.xsender.models.SunatResponse;
import io.github.project.openubl.xsender.models.rest.ResponseDocumentErrorDto;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.http.base.HttpOperationFailedException;

public class RestSunatErrorResponseProcessor
implements Processor {
    public void process(Exchange exchange) throws Exception {
        HttpOperationFailedException httpException = (HttpOperationFailedException)exchange.getProperty("CamelExceptionCaught", HttpOperationFailedException.class);
        ResponseDocumentErrorDto responseDocumentErrorDto = (ResponseDocumentErrorDto)exchange.getIn().getBody(ResponseDocumentErrorDto.class);
        String responseCode = Optional.ofNullable(responseDocumentErrorDto.getCod()).orElse(responseDocumentErrorDto.getStatus());
        int responseCodeInt = Integer.parseInt(responseCode);
        String responseDescription = Optional.ofNullable(responseDocumentErrorDto.getMsg()).orElse(responseDocumentErrorDto.getMessage());
        List<String> notes = Optional.ofNullable(responseDocumentErrorDto.getErrors()).orElse(Collections.emptyList()).stream().map(error -> error.getCod() + " - " + error.getMsg()).collect(Collectors.toList());
        SunatResponse sunatResponse = SunatResponse.builder().status(Status.fromCode(responseCodeInt)).metadata(Metadata.builder().notes(notes).responseCode(responseCodeInt).description(responseDescription).build()).build();
        exchange.getIn().setBody((Object)sunatResponse);
    }
}

