/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xsender.camel.routes;

import io.github.project.openubl.xsender.camel.routes.RestSunatErrorResponseProcessor;
import io.github.project.openubl.xsender.camel.routes.RestSunatResponseProcessor;
import io.github.project.openubl.xsender.camel.routes.SoapSunatErrorResponseProcessor;
import io.github.project.openubl.xsender.camel.routes.SoapSunatResponseProcessor;
import io.github.project.openubl.xsender.models.Metadata;
import io.github.project.openubl.xsender.models.Status;
import io.github.project.openubl.xsender.models.SunatResponse;
import io.github.project.openubl.xsender.models.rest.ResponseAccessTokenSuccessDto;
import io.github.project.openubl.xsender.models.rest.ResponseDocumentErrorDto;
import io.github.project.openubl.xsender.models.rest.ResponseDocumentSuccessDto;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.component.jackson.JacksonDataFormat;
import org.apache.camel.http.base.HttpOperationFailedException;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.URISupport;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.transport.http.HTTPException;

public class SunatRouteBuilder
extends RouteBuilder {
    public void configure() {
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from("direct:xsender-billService").id("xsender-billService")).choice().when(this.header("operationName").isNotNull()).to("cxf://bean:cxfBillServiceEndpoint?dataFormat=POJO")).process((Processor)new SoapSunatResponseProcessor())).endChoice().when(this.header("CamelHttpMethod").isNotNull()).marshal().json(JsonLibrary.Jackson).to("https://api-cpe.sunat.gob.pe")).unmarshal((DataFormat)new JacksonDataFormat(ResponseDocumentSuccessDto.class))).process((Processor)new RestSunatResponseProcessor())).endChoice().otherwise().throwException((Exception)new RuntimeException("Not supported protocol identified"))).endChoice().end().onException(SoapFault.class).continued(true).process((Processor)new SoapSunatErrorResponseProcessor())).end().onException(HTTPException.class).continued(true).maximumRedeliveries(1).useOriginalMessage().process(exchange -> {
            Throwable throwable = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
            SunatResponse sunatResponse = SunatResponse.builder().status(Status.UNKNOWN).metadata(Metadata.builder().notes(Collections.emptyList()).description(throwable.getMessage()).build()).build();
            exchange.getIn().setBody((Object)sunatResponse);
        })).end().onException(HttpOperationFailedException.class).continued(exchange -> {
            HttpOperationFailedException httpException = (HttpOperationFailedException)exchange.getProperty("CamelExceptionCaught", HttpOperationFailedException.class);
            String contentType = httpException.getResponseHeaders().getOrDefault("Content-Type", "");
            boolean isResponseJson = Objects.equals(contentType, "application/json");
            if (isResponseJson) {
                exchange.getIn().setBody((Object)httpException.getResponseBody());
            }
            exchange.getIn().setHeader("HttpResponseHeader_ContentType", (Object)contentType);
            return isResponseJson;
        }).choice().when(this.header("HttpResponseHeader_ContentType").isEqualTo((Object)"application/json")).unmarshal((DataFormat)new JacksonDataFormat(ResponseDocumentErrorDto.class))).process((Processor)new RestSunatErrorResponseProcessor())).endChoice().otherwise().log(LoggingLevel.WARN, "Response from server is not JSON, something went wrong while connecting to the remote server")).endChoice().end().end();
        ((RouteDefinition)this.from("direct:xsender-billConsultService").id("xsender-billConsultService")).to("cxf://bean:cxfBillConsultServiceEndpoint?dataFormat=POJO");
        ((RouteDefinition)this.from("direct:xsender-billValidService").id("xsender-billValidService")).to("cxf://bean:cxfBillValidServiceEndpoint?dataFormat=POJO");
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from("direct:xsender-credentialsApi").id("xsender-credentialsApi")).choice().when(exchange -> {
            List body = (List)exchange.getIn().getBody(List.class);
            ResponseAccessTokenSuccessDto prevToken = (ResponseAccessTokenSuccessDto)body.get(0);
            ZonedDateTime prevTokenCreatedIn = prevToken.getCreated_in();
            ZonedDateTime expirationDate = prevTokenCreatedIn.plusSeconds(prevToken.getExpires_in()).plusSeconds(30L);
            return ZonedDateTime.now().compareTo(expirationDate) >= 0;
        }).setHeader("CamelHttpMethod", (Expression)this.constant(HttpMethods.POST))).setHeader("Content-Type", (Expression)this.constant("application/x-www-form-urlencoded"))).setBody(exchange -> {
            List body = (List)exchange.getIn().getBody(List.class);
            Map map = (Map)body.get(1);
            try {
                return URISupport.createQueryString((Map)map);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        })).to("https://api-seguridad.sunat.gob.pe")).unmarshal((DataFormat)new JacksonDataFormat(ResponseAccessTokenSuccessDto.class))).process(exchange -> {
            ResponseAccessTokenSuccessDto response = (ResponseAccessTokenSuccessDto)exchange.getIn().getBody(ResponseAccessTokenSuccessDto.class);
            response.setCreated_in(ZonedDateTime.now());
        })).endChoice().otherwise().setBody(exchange -> {
            List body = (List)exchange.getIn().getBody(List.class);
            return (ResponseAccessTokenSuccessDto)body.get(0);
        })).endChoice().end();
    }
}

