/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xsender.files;

import io.github.project.openubl.xsender.company.CompanyURLs;
import io.github.project.openubl.xsender.files.BillServiceFileAnalyzer;
import io.github.project.openubl.xsender.files.ZipFile;
import io.github.project.openubl.xsender.files.exceptions.UnsupportedXMLFileException;
import io.github.project.openubl.xsender.files.xml.XmlContent;
import io.github.project.openubl.xsender.files.xml.XmlContentProvider;
import io.github.project.openubl.xsender.sunat.BillServiceDestination;
import io.github.project.openubl.xsender.sunat.catalog.Catalog1;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import jodd.io.ZipBuilder;
import org.apache.cxf.helpers.IOUtils;
import org.xml.sax.SAXException;

public class BillServiceXMLFileAnalyzer
implements BillServiceFileAnalyzer {
    private static final String FILENAME_FORMAT1 = "{0}-{1}-{2}";
    private static final String FILENAME_FORMAT2 = "{0}-{1}";
    private final ZipFile zipFile;
    private final BillServiceDestination fileDestination;
    private final BillServiceDestination ticketDestination;
    private final XmlContent xmlContent;

    public BillServiceXMLFileAnalyzer(File file, CompanyURLs urLs) throws IOException, ParserConfigurationException, UnsupportedXMLFileException, SAXException {
        this(file.toPath(), urLs);
    }

    public BillServiceXMLFileAnalyzer(Path path, CompanyURLs urLs) throws IOException, ParserConfigurationException, UnsupportedXMLFileException, SAXException {
        this(Files.readAllBytes(path), urLs);
    }

    public BillServiceXMLFileAnalyzer(InputStream is, CompanyURLs urLs) throws IOException, ParserConfigurationException, UnsupportedXMLFileException, SAXException {
        this(IOUtils.readBytesFromStream((InputStream)is), urLs);
    }

    public BillServiceXMLFileAnalyzer(byte[] file, CompanyURLs urls) throws ParserConfigurationException, IOException, SAXException, UnsupportedXMLFileException {
        String voidedLineDocumentTypeCode;
        Optional<Catalog1> catalog1Optional;
        this.xmlContent = XmlContentProvider.getSunatDocument(new ByteArrayInputStream(file));
        if (!this.xmlContent.getDocumentType().equals("VoidedDocuments") || !(catalog1Optional = Catalog1.valueOfCode(voidedLineDocumentTypeCode = this.xmlContent.getVoidedLineDocumentTypeCode())).isPresent() || catalog1Optional.get().equals((Object)Catalog1.BOLETA)) {
            // empty if block
        }
        String fileNameWithoutExtension = BillServiceXMLFileAnalyzer.getFileNameWithoutExtension(this.xmlContent).orElseThrow(() -> new UnsupportedXMLFileException("Couldn't infer the file name"));
        BillServiceDestination fileDestination = BillServiceXMLFileAnalyzer.getFileDeliveryTarget(urls, this.xmlContent).orElseThrow(() -> new UnsupportedXMLFileException("Couldn't infer the delivery data"));
        BillServiceDestination ticketDestination = BillServiceXMLFileAnalyzer.getTicketDeliveryTarget(urls, this.xmlContent).orElse(null);
        String zipFileName = fileNameWithoutExtension + ".zip";
        byte[] zipFile = ZipBuilder.createZipInMemory().add(file).path(fileNameWithoutExtension + ".xml").save().toBytes();
        this.zipFile = new ZipFile(zipFile, zipFileName);
        this.fileDestination = fileDestination;
        this.ticketDestination = ticketDestination;
    }

    @Override
    public ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public BillServiceDestination getSendFileDestination() {
        return this.fileDestination;
    }

    @Override
    public BillServiceDestination getVerifyTicketDestination() {
        return this.ticketDestination;
    }

    @Override
    public XmlContent getXmlContent() {
        return this.xmlContent;
    }

    private static Optional<String> getFileNameWithoutExtension(XmlContent xmlContent) {
        String documentType = xmlContent.getDocumentType();
        String documentID = xmlContent.getDocumentID();
        String ruc = xmlContent.getRuc();
        String result = null;
        switch (documentType) {
            case "Invoice": {
                String codigoDocumento;
                if (Pattern.compile("^[F|f].*$").matcher(documentID).find()) {
                    codigoDocumento = Catalog1.FACTURA.getCode();
                } else if (Pattern.compile("^[B|b].*$").matcher(documentID).find()) {
                    codigoDocumento = Catalog1.BOLETA.getCode();
                } else {
                    throw new IllegalStateException("Invalid Serie, can not detect code");
                }
                result = MessageFormat.format(FILENAME_FORMAT1, ruc, codigoDocumento, documentID);
                break;
            }
            case "CreditNote": {
                String codigoDocumento = Catalog1.NOTA_CREDITO.getCode();
                result = MessageFormat.format(FILENAME_FORMAT1, ruc, codigoDocumento, documentID);
                break;
            }
            case "DebitNote": {
                String codigoDocumento = Catalog1.NOTA_DEBITO.getCode();
                result = MessageFormat.format(FILENAME_FORMAT1, ruc, codigoDocumento, documentID);
                break;
            }
            case "VoidedDocuments": 
            case "SummaryDocuments": {
                result = MessageFormat.format(FILENAME_FORMAT2, ruc, documentID);
                break;
            }
            case "Perception": {
                String codigoDocumento = Catalog1.PERCEPCION.getCode();
                result = MessageFormat.format(FILENAME_FORMAT1, ruc, codigoDocumento, documentID);
                break;
            }
            case "Retention": {
                String codigoDocumento = Catalog1.RETENCION.getCode();
                result = MessageFormat.format(FILENAME_FORMAT1, ruc, codigoDocumento, documentID);
                break;
            }
            case "DespatchAdvice": {
                String codigoDocumento;
                if (Pattern.compile("^[T|t].*$").matcher(documentID).find()) {
                    codigoDocumento = Catalog1.GUIA_REMISION_REMITENTE.getCode();
                } else if (Pattern.compile("^[V|v].*$").matcher(documentID).find()) {
                    codigoDocumento = Catalog1.GUIA_REMISION_TRANSPORTISTA.getCode();
                } else {
                    throw new IllegalStateException("Invalid Serie, can not detect code");
                }
                result = MessageFormat.format(FILENAME_FORMAT1, ruc, codigoDocumento, documentID);
            }
        }
        return Optional.ofNullable(result);
    }

    public static Optional<BillServiceDestination> getFileDeliveryTarget(CompanyURLs urls, XmlContent xmlContent) {
        BillServiceDestination fileDeliveryTarget = null;
        switch (xmlContent.getDocumentType()) {
            case "Invoice": 
            case "CreditNote": 
            case "DebitNote": {
                fileDeliveryTarget = BillServiceDestination.builder().url(urls.getInvoice()).soapOperation(BillServiceDestination.SoapOperation.SEND_BILL).build();
                break;
            }
            case "SummaryDocuments": {
                fileDeliveryTarget = BillServiceDestination.builder().url(urls.getInvoice()).soapOperation(BillServiceDestination.SoapOperation.SEND_SUMMARY).build();
                break;
            }
            case "VoidedDocuments": {
                String tipoDocumentoAfectado = xmlContent.getVoidedLineDocumentTypeCode();
                Optional<Catalog1> catalog1Optional = Catalog1.valueOfCode(tipoDocumentoAfectado);
                if (!catalog1Optional.isPresent()) {
                    return Optional.empty();
                }
                Catalog1 catalog1 = catalog1Optional.get();
                String deliveryUrl = catalog1.equals((Object)Catalog1.PERCEPCION) || catalog1.equals((Object)Catalog1.RETENCION) ? urls.getPerceptionRetention() : (catalog1.equals((Object)Catalog1.GUIA_REMISION_REMITENTE) ? urls.getDespatch() : urls.getInvoice());
                fileDeliveryTarget = BillServiceDestination.builder().url(deliveryUrl).soapOperation(BillServiceDestination.SoapOperation.SEND_SUMMARY).build();
                break;
            }
            case "Perception": 
            case "Retention": {
                fileDeliveryTarget = BillServiceDestination.builder().url(urls.getPerceptionRetention()).soapOperation(BillServiceDestination.SoapOperation.SEND_BILL).build();
                break;
            }
            case "DespatchAdvice": {
                fileDeliveryTarget = BillServiceDestination.builder().url(urls.getDespatch()).restOperation(BillServiceDestination.RestOperation.SEND_DOCUMENT).build();
            }
        }
        return Optional.ofNullable(fileDeliveryTarget);
    }

    public static Optional<BillServiceDestination> getTicketDeliveryTarget(CompanyURLs urls, XmlContent xmlContent) {
        BillServiceDestination ticketDeliveryTarget;
        block5 : switch (xmlContent.getDocumentType()) {
            case "VoidedDocuments": {
                Catalog1 catalog1 = Catalog1.valueOfCode(xmlContent.getVoidedLineDocumentTypeCode()).orElse(Catalog1.FACTURA);
                switch (catalog1) {
                    case PERCEPCION: 
                    case RETENCION: {
                        ticketDeliveryTarget = BillServiceDestination.builder().url(urls.getPerceptionRetention()).soapOperation(BillServiceDestination.SoapOperation.GET_STATUS).build();
                        break block5;
                    }
                    case GUIA_REMISION_REMITENTE: 
                    case GUIA_REMISION_TRANSPORTISTA: {
                        ticketDeliveryTarget = null;
                        break block5;
                    }
                }
                ticketDeliveryTarget = BillServiceDestination.builder().url(urls.getInvoice()).soapOperation(BillServiceDestination.SoapOperation.GET_STATUS).build();
                break;
            }
            case "SummaryDocuments": {
                ticketDeliveryTarget = BillServiceDestination.builder().url(urls.getInvoice()).soapOperation(BillServiceDestination.SoapOperation.GET_STATUS).build();
                break;
            }
            case "DespatchAdvice": {
                ticketDeliveryTarget = BillServiceDestination.builder().url(urls.getDespatch()).restOperation(BillServiceDestination.RestOperation.VERIFY_TICKET).build();
                break;
            }
            default: {
                ticketDeliveryTarget = null;
            }
        }
        return Optional.ofNullable(ticketDeliveryTarget);
    }
}

