/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xsender.files;

import java.util.Arrays;

public class ZipFile {
    private final byte[] file;
    private final String filename;

    public static ZipFileBuilder builder() {
        return new ZipFileBuilder();
    }

    public byte[] getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZipFile)) {
            return false;
        }
        ZipFile other = (ZipFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getFile(), other.getFile())) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        return !(this$filename == null ? other$filename != null : !this$filename.equals(other$filename));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZipFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getFile());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        return result;
    }

    public String toString() {
        return "ZipFile(file=" + Arrays.toString(this.getFile()) + ", filename=" + this.getFilename() + ")";
    }

    public ZipFile(byte[] file, String filename) {
        this.file = file;
        this.filename = filename;
    }

    public static class ZipFileBuilder {
        private byte[] file;
        private String filename;

        ZipFileBuilder() {
        }

        public ZipFileBuilder file(byte[] file) {
            this.file = file;
            return this;
        }

        public ZipFileBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public ZipFile build() {
            return new ZipFile(this.file, this.filename);
        }

        public String toString() {
            return "ZipFile.ZipFileBuilder(file=" + Arrays.toString(this.file) + ", filename=" + this.filename + ")";
        }
    }
}

