/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xsender.files.xml;

import io.github.project.openubl.xsender.files.xml.XmlContent;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlHandler
extends DefaultHandler {
    private static final String CBC = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";
    private static final String CAC = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2";
    private static final String SAC = "urn:sunat:names:specification:ubl:peru:schema:xsd:SunatAggregateComponents-1";
    private static final String EXT = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2";
    private static final String ACCOUNTING_SUPPLIER_PARTY = "AccountingSupplierParty";
    private static final String PARTY = "Party";
    private static final String PARTY_IDENTIFICATION = "PartyIdentification";
    private static final String ID = "ID";
    private static final String CUSTOMER_ASSIGNED_ACCOUNT_ID = "CustomerAssignedAccountID";
    private static final String AGENT_PARTY = "AgentParty";
    private static final String UBL_EXTENSIONS = "UBLExtensions";
    private static final String SIGNATURE = "Signature";
    private static final String VOIDED_DOCUMENTS_LINE = "VoidedDocumentsLine";
    private static final String DOCUMENT_TYPE_CODE = "DocumentTypeCode";
    private String documentType;
    private String documentID;
    private String ruc;
    private String voidedLineDocumentTypeCode;
    private boolean isAccountingSupplierPartyBeingRead;
    private boolean isPartyBeingRead;
    private boolean isPartyIdentificationBeingRead;
    private boolean isAgentPartyBeingRead;
    private boolean isUBLExtensionsBeingRead;
    private boolean isSignatureBeingRead;
    private boolean isVoidedDocumentsLineBeingRead;
    private String currentElement;
    private StringBuilder currentText;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        this.currentElement = localName;
        if (this.documentType == null) {
            this.documentType = this.currentElement;
        }
        if (this.currentElement.equals(ID) && uri.equals(CBC)) {
            this.currentText = new StringBuilder();
        } else if (this.currentElement.equals(ACCOUNTING_SUPPLIER_PARTY) && uri.equals(CAC)) {
            this.isAccountingSupplierPartyBeingRead = true;
        } else if (this.currentElement.equals(PARTY) && uri.equals(CAC)) {
            this.isPartyBeingRead = true;
        } else if (this.currentElement.equals(PARTY_IDENTIFICATION) && uri.equals(CAC)) {
            this.isPartyIdentificationBeingRead = true;
        } else if (this.currentElement.equals(AGENT_PARTY) && uri.equals(CAC)) {
            this.isAgentPartyBeingRead = true;
        } else if (this.currentElement.equals(UBL_EXTENSIONS) && uri.equals(EXT)) {
            this.isUBLExtensionsBeingRead = true;
        } else if (this.currentElement.equals(SIGNATURE) && uri.equals(CAC)) {
            this.isSignatureBeingRead = true;
        } else if (this.currentElement.equals(VOIDED_DOCUMENTS_LINE) && uri.equals(SAC)) {
            this.isVoidedDocumentsLineBeingRead = true;
        } else if (this.currentElement.equals(CUSTOMER_ASSIGNED_ACCOUNT_ID) && uri.equals(CBC)) {
            this.currentText = new StringBuilder();
        } else if (this.currentElement.equals(DOCUMENT_TYPE_CODE) && uri.equals(CBC)) {
            this.currentText = new StringBuilder();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentText != null) {
            String content = this.currentText.toString().trim();
            if (this.currentElement.equals(ID) && uri.equals(CBC)) {
                if (this.documentID == null && !this.isSignatureBeingRead && !this.isUBLExtensionsBeingRead) {
                    this.documentID = content;
                }
                if (this.isAccountingSupplierPartyBeingRead && this.isPartyBeingRead && this.isPartyIdentificationBeingRead || this.isAgentPartyBeingRead && this.isPartyIdentificationBeingRead) {
                    this.ruc = content;
                }
            } else if (this.currentElement.equals(CUSTOMER_ASSIGNED_ACCOUNT_ID) && uri.equals(CBC)) {
                if (this.ruc == null) {
                    this.ruc = content;
                }
            } else if (this.currentElement.equals(DOCUMENT_TYPE_CODE) && uri.equals(CBC) && this.voidedLineDocumentTypeCode == null && this.isVoidedDocumentsLineBeingRead) {
                this.voidedLineDocumentTypeCode = content;
            }
            this.currentText = null;
        }
        if (localName.equals(ACCOUNTING_SUPPLIER_PARTY) && uri.equals(CAC)) {
            this.isAccountingSupplierPartyBeingRead = false;
        } else if (localName.equals(PARTY) && uri.equals(CAC)) {
            this.isPartyBeingRead = false;
        } else if (localName.equals(PARTY_IDENTIFICATION) && uri.equals(CAC)) {
            this.isPartyIdentificationBeingRead = false;
        } else if (localName.equals(AGENT_PARTY) && uri.equals(CAC)) {
            this.isAgentPartyBeingRead = false;
        } else if (localName.equals(VOIDED_DOCUMENTS_LINE) && uri.equals(SAC)) {
            this.isVoidedDocumentsLineBeingRead = false;
        } else if (localName.equals(UBL_EXTENSIONS) && uri.equals(EXT)) {
            this.isUBLExtensionsBeingRead = false;
        } else if (localName.equals(SIGNATURE) && uri.equals(CAC)) {
            this.isSignatureBeingRead = false;
        }
        this.currentElement = "";
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentText != null) {
            this.currentText.append(ch, start, length);
        }
    }

    public XmlContent getModel() {
        return XmlContent.builder().documentType(this.documentType).documentID(this.documentID).ruc(this.ruc).voidedLineDocumentTypeCode(this.voidedLineDocumentTypeCode).build();
    }
}

