/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xsender.models.rest;

import io.github.project.openubl.xsender.files.ZipFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.apache.commons.codec.binary.Hex;

public class PayloadDocumentDto {
    private Archivo archivo;

    public static PayloadDocumentDto build(ZipFile zipFile) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] hashZip = digest.digest(zipFile.getFile());
        byte[] base64Zip = Base64.getEncoder().encode(zipFile.getFile());
        return PayloadDocumentDto.builder().archivo(Archivo.builder().nomArchivo(zipFile.getFilename()).arcGreZip(new String(base64Zip)).hashZip(new String(Hex.encodeHex((byte[])hashZip))).build()).build();
    }

    public static PayloadDocumentDtoBuilder builder() {
        return new PayloadDocumentDtoBuilder();
    }

    public Archivo getArchivo() {
        return this.archivo;
    }

    public void setArchivo(Archivo archivo) {
        this.archivo = archivo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayloadDocumentDto)) {
            return false;
        }
        PayloadDocumentDto other = (PayloadDocumentDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Archivo this$archivo = this.getArchivo();
        Archivo other$archivo = other.getArchivo();
        return !(this$archivo == null ? other$archivo != null : !((Object)this$archivo).equals(other$archivo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PayloadDocumentDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Archivo $archivo = this.getArchivo();
        result = result * 59 + ($archivo == null ? 43 : ((Object)$archivo).hashCode());
        return result;
    }

    public String toString() {
        return "PayloadDocumentDto(archivo=" + this.getArchivo() + ")";
    }

    public PayloadDocumentDto() {
    }

    public PayloadDocumentDto(Archivo archivo) {
        this.archivo = archivo;
    }

    public static class PayloadDocumentDtoBuilder {
        private Archivo archivo;

        PayloadDocumentDtoBuilder() {
        }

        public PayloadDocumentDtoBuilder archivo(Archivo archivo) {
            this.archivo = archivo;
            return this;
        }

        public PayloadDocumentDto build() {
            return new PayloadDocumentDto(this.archivo);
        }

        public String toString() {
            return "PayloadDocumentDto.PayloadDocumentDtoBuilder(archivo=" + this.archivo + ")";
        }
    }

    public static class Archivo {
        private String nomArchivo;
        private String arcGreZip;
        private String hashZip;

        public static ArchivoBuilder builder() {
            return new ArchivoBuilder();
        }

        public String getNomArchivo() {
            return this.nomArchivo;
        }

        public String getArcGreZip() {
            return this.arcGreZip;
        }

        public String getHashZip() {
            return this.hashZip;
        }

        public void setNomArchivo(String nomArchivo) {
            this.nomArchivo = nomArchivo;
        }

        public void setArcGreZip(String arcGreZip) {
            this.arcGreZip = arcGreZip;
        }

        public void setHashZip(String hashZip) {
            this.hashZip = hashZip;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Archivo)) {
                return false;
            }
            Archivo other = (Archivo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$nomArchivo = this.getNomArchivo();
            String other$nomArchivo = other.getNomArchivo();
            if (this$nomArchivo == null ? other$nomArchivo != null : !this$nomArchivo.equals(other$nomArchivo)) {
                return false;
            }
            String this$arcGreZip = this.getArcGreZip();
            String other$arcGreZip = other.getArcGreZip();
            if (this$arcGreZip == null ? other$arcGreZip != null : !this$arcGreZip.equals(other$arcGreZip)) {
                return false;
            }
            String this$hashZip = this.getHashZip();
            String other$hashZip = other.getHashZip();
            return !(this$hashZip == null ? other$hashZip != null : !this$hashZip.equals(other$hashZip));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Archivo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $nomArchivo = this.getNomArchivo();
            result = result * 59 + ($nomArchivo == null ? 43 : $nomArchivo.hashCode());
            String $arcGreZip = this.getArcGreZip();
            result = result * 59 + ($arcGreZip == null ? 43 : $arcGreZip.hashCode());
            String $hashZip = this.getHashZip();
            result = result * 59 + ($hashZip == null ? 43 : $hashZip.hashCode());
            return result;
        }

        public String toString() {
            return "PayloadDocumentDto.Archivo(nomArchivo=" + this.getNomArchivo() + ", arcGreZip=" + this.getArcGreZip() + ", hashZip=" + this.getHashZip() + ")";
        }

        public Archivo() {
        }

        public Archivo(String nomArchivo, String arcGreZip, String hashZip) {
            this.nomArchivo = nomArchivo;
            this.arcGreZip = arcGreZip;
            this.hashZip = hashZip;
        }

        public static class ArchivoBuilder {
            private String nomArchivo;
            private String arcGreZip;
            private String hashZip;

            ArchivoBuilder() {
            }

            public ArchivoBuilder nomArchivo(String nomArchivo) {
                this.nomArchivo = nomArchivo;
                return this;
            }

            public ArchivoBuilder arcGreZip(String arcGreZip) {
                this.arcGreZip = arcGreZip;
                return this;
            }

            public ArchivoBuilder hashZip(String hashZip) {
                this.hashZip = hashZip;
                return this;
            }

            public Archivo build() {
                return new Archivo(this.nomArchivo, this.arcGreZip, this.hashZip);
            }

            public String toString() {
                return "PayloadDocumentDto.Archivo.ArchivoBuilder(nomArchivo=" + this.nomArchivo + ", arcGreZip=" + this.arcGreZip + ", hashZip=" + this.hashZip + ")";
            }
        }
    }
}

