/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xsender.utils;

import io.github.project.openubl.xsender.models.Metadata;
import io.github.project.openubl.xsender.models.Status;
import io.github.project.openubl.xsender.utils.ByteUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CdrReader {
    private final byte[] zipFile;
    private Status status;
    private final Metadata metadata;

    public CdrReader(byte[] zipFile) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        this.zipFile = zipFile;
        byte[] xml = ByteUtils.getFirstXmlFileFromZip(zipFile);
        Document document = ByteUtils.getDocumentFromBytes(xml);
        this.metadata = this.readContent(document);
        this.status = Status.fromCode(this.metadata.getResponseCode());
    }

    private Metadata readContent(Document document) throws XPathExpressionException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if ("ar".equals(prefix)) {
                    return "urn:oasis:names:specification:ubl:schema:xsd:ApplicationResponse-2";
                }
                if ("ext".equals(prefix)) {
                    return "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2";
                }
                if ("cbc".equals(prefix)) {
                    return "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";
                }
                if ("cac".equals(prefix)) {
                    return "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2";
                }
                return null;
            }

            @Override
            public String getPrefix(String s) {
                return null;
            }

            public Iterator getPrefixes(String s) {
                return null;
            }
        });
        XPathExpression codeXPathExpression = xPath.compile("//ar:ApplicationResponse/cac:DocumentResponse/cac:Response/cbc:ResponseCode");
        String code = (String)codeXPathExpression.evaluate(document, XPathConstants.STRING);
        XPathExpression descriptionXPathExpression = xPath.compile("//ar:ApplicationResponse/cac:DocumentResponse/cac:Response/cbc:Description");
        String description = (String)descriptionXPathExpression.evaluate(document, XPathConstants.STRING);
        XPathExpression notesXPathExpression = xPath.compile("//ar:ApplicationResponse/cbc:Note");
        NodeList noteNodes = (NodeList)notesXPathExpression.evaluate(document, XPathConstants.NODESET);
        ArrayList<String> notes = new ArrayList<String>();
        for (int index = 0; index < noteNodes.getLength(); ++index) {
            Node node = noteNodes.item(index);
            notes.add(node.getTextContent());
        }
        int responseCode = Integer.parseInt(code);
        return new Metadata(responseCode, description, notes);
    }

    public byte[] getZipFile() {
        return this.zipFile;
    }

    public Status getStatus() {
        return this.status;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CdrReader)) {
            return false;
        }
        CdrReader other = (CdrReader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getZipFile(), other.getZipFile())) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CdrReader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getZipFile());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "CdrReader(zipFile=" + Arrays.toString(this.getZipFile()) + ", status=" + this.getStatus() + ", metadata=" + this.getMetadata() + ")";
    }
}

