/*
 * Decompiled with CFR 0.152.
 */
package io.github.easyannotation.autoconfig;

import io.github.easyannotation.annotation.AnnotationConfigurationScan;
import io.github.easyannotation.annotation.AnnotationScan;
import io.github.easyannotation.processor.AbstractAnnotationProcessor;
import io.github.easyannotation.util.AnnotationUtil;
import io.github.easyannotation.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class AnnotationPostProcessor
implements BeanDefinitionRegistryPostProcessor,
BeanFactoryAware,
EnvironmentAware,
ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnnotationPostProcessor.class);
    private BeanFactory beanFactory;
    private ApplicationContext applicationContext;
    private DefaultListableBeanFactory registry;
    private Environment environment;
    private Map<String, AbstractAnnotationProcessor> processors = new HashMap<String, AbstractAnnotationProcessor>();

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = (DefaultListableBeanFactory)registry;
        this.initProcessors();
        for (AbstractAnnotationProcessor processor : this.processors.values()) {
            processor.processorInit();
        }
        List packageNames = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
        for (String packageName : packageNames) {
            log.info("* Package {} > Scan AnnotationScan start ...", (Object)packageName);
            this.postProcessAnnotationScan(packageName);
            log.info("* Package {} > Scan AnnotationScan finished ...", (Object)packageName);
            log.info("* Package {} > Scan AnnotationFieldConfigScan start ...", (Object)packageName);
            this.postProcessAnnotationConfigurationScan(packageName);
            log.info("* Package {} > Scan AnnotationFieldConfigScan finished ...", (Object)packageName);
            this.postProcessAnnotationFieldProperties(packageName);
        }
        for (AbstractAnnotationProcessor processor : this.processors.values()) {
            processor.afterAllProcesses();
        }
    }

    private void postProcessAnnotationFieldProperties(String packageName) {
        for (AbstractAnnotationProcessor processor : this.processors.values()) {
            if (processor.getAnnotationFieldProperty() == null) continue;
            this.postProcessAnnotationFieldProperty(packageName, processor);
        }
    }

    private void postProcessAnnotationFieldProperty(String packageName, AbstractAnnotationProcessor processor) {
        Set<BeanDefinition> beans = AnnotationUtil.getBeanDefinitions(packageName, processor.getAnnotationFieldProperty().getDependOn());
        for (BeanDefinition bean : beans) {
            Class<?> clazz = ClassUtil.getClass(bean.getBeanClassName());
            if (clazz == null) continue;
            for (Field field : clazz.getDeclaredFields()) {
                this.processField(processor, field, processor.getAnnotationFieldProperty().getField());
            }
        }
    }

    private void postProcessAnnotationScan(String packageName) {
        Set<BeanDefinition> beans = AnnotationUtil.getBeanDefinitions(packageName, AnnotationScan.class);
        for (BeanDefinition bean : beans) {
            AbstractAnnotationProcessor processor;
            AnnotationScan annotationScan;
            Class<?> clazz = ClassUtil.getClass(bean.getBeanClassName());
            if (clazz == null || clazz.isAnnotation() || (annotationScan = AnnotationUtil.getAnnotationScan(AnnotationScan.class, clazz)) == null || (processor = this.getPostProcessor(annotationScan.processor())) == null) continue;
            processor.processClass(bean, clazz, clazz.getAnnotations()[0]);
        }
    }

    private void postProcessAnnotationConfigurationScan(String packageName) {
        Set<BeanDefinition> beans = AnnotationUtil.getBeanDefinitions(packageName, AnnotationConfigurationScan.class);
        for (BeanDefinition bean : beans) {
            AbstractAnnotationProcessor processor;
            AnnotationConfigurationScan annotationScan;
            Class<?> clazz = ClassUtil.getClass(bean.getBeanClassName());
            if (clazz == null || (annotationScan = AnnotationUtil.getAnnotationScan(AnnotationConfigurationScan.class, clazz)) == null || annotationScan.fieldAnnotation() == null || (processor = this.getPostProcessor(annotationScan.processor())) == null) continue;
            for (Field field : clazz.getDeclaredFields()) {
                this.processField(processor, field, annotationScan.fieldAnnotation());
            }
        }
    }

    private void processField(AbstractAnnotationProcessor processor, Field field, Class<? extends Annotation> fieldAnnotation) {
        Annotation[] annotations = field.getAnnotationsByType(fieldAnnotation);
        if (annotations.length == 0) {
            return;
        }
        processor.processField(field, annotations[0]);
    }

    private void initProcessors() {
        Map beans = this.applicationContext.getBeansOfType(AbstractAnnotationProcessor.class);
        for (AbstractAnnotationProcessor processor : beans.values()) {
            processor.setRegistry(this.registry);
            processor.setEnvironment(this.environment);
            processor.setBeanFactory(this.beanFactory);
            processor.setApplicationContext(this.applicationContext);
            this.processors.put(processor.getClass().getName(), processor);
        }
    }

    private AbstractAnnotationProcessor getPostProcessor(Class<? extends AbstractAnnotationProcessor> clazz) {
        if (this.processors.containsKey(clazz.getName())) {
            return this.processors.get(clazz.getName());
        }
        return null;
    }
}

