/*
 * Decompiled with CFR 0.152.
 */
package io.github.easyannotation.util;

import io.github.easyannotation.autoconfig.AnnotationScanner;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class AnnotationUtil {
    public static Set<BeanDefinition> getBeanDefinitions(String packageName, Class<? extends Annotation> annotationType) {
        return AnnotationUtil.getBeanDefinitions(packageName, Collections.singletonList(annotationType), null);
    }

    public static Set<BeanDefinition> getBeanDefinitions(String packageName, List<Class<? extends Annotation>> annotationTypes) {
        return AnnotationUtil.getBeanDefinitions(packageName, annotationTypes, null);
    }

    public static Set<BeanDefinition> getBeanDefinitions(String packageName, List<Class<? extends Annotation>> annotationTypes, Class<?> classType) {
        AnnotationScanner provider = new AnnotationScanner(false);
        if (!annotationTypes.isEmpty()) {
            for (Class<? extends Annotation> annotationType : annotationTypes) {
                provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType));
            }
        }
        if (classType != null) {
            provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(classType));
        }
        return provider.findCandidateComponents(packageName);
    }

    public static <T extends Annotation> T getAnnotationScan(Class<T> annotationClazz, Class<?> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (annotationClazz.getName().equals(annotation.annotationType().getName())) {
                return (T)annotation;
            }
            T a = annotation.annotationType().getAnnotation(annotationClazz);
            if (a == null) continue;
            return a;
        }
        return null;
    }
}

