/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog.jpl;

import io.github.prolobjectlink.prolog.AbstractConverter;
import io.github.prolobjectlink.prolog.PrologAtom;
import io.github.prolobjectlink.prolog.PrologConverter;
import io.github.prolobjectlink.prolog.PrologDouble;
import io.github.prolobjectlink.prolog.PrologFloat;
import io.github.prolobjectlink.prolog.PrologInteger;
import io.github.prolobjectlink.prolog.PrologLong;
import io.github.prolobjectlink.prolog.PrologStructure;
import io.github.prolobjectlink.prolog.PrologTerm;
import io.github.prolobjectlink.prolog.PrologVariable;
import io.github.prolobjectlink.prolog.UnknownTermError;
import io.github.prolobjectlink.prolog.jpl.JplAtom;
import io.github.prolobjectlink.prolog.jpl.JplCut;
import io.github.prolobjectlink.prolog.jpl.JplEmpty;
import io.github.prolobjectlink.prolog.jpl.JplFail;
import io.github.prolobjectlink.prolog.jpl.JplFalse;
import io.github.prolobjectlink.prolog.jpl.JplFloat;
import io.github.prolobjectlink.prolog.jpl.JplInteger;
import io.github.prolobjectlink.prolog.jpl.JplList;
import io.github.prolobjectlink.prolog.jpl.JplLong;
import io.github.prolobjectlink.prolog.jpl.JplNil;
import io.github.prolobjectlink.prolog.jpl.JplReference;
import io.github.prolobjectlink.prolog.jpl.JplStructure;
import io.github.prolobjectlink.prolog.jpl.JplTrue;
import io.github.prolobjectlink.prolog.jpl.JplVariable;
import java.util.ArrayList;
import jpl.Atom;
import jpl.Compound;
import jpl.Float;
import jpl.Integer;
import jpl.JPL;
import jpl.JPLException;
import jpl.Query;
import jpl.Term;
import jpl.Variable;

public abstract class JplConverter
extends AbstractConverter<Term>
implements PrologConverter<Term> {
    public final PrologTerm toTerm(Term prologTerm) {
        if (prologTerm.isAtom()) {
            String functor = prologTerm.name();
            if (functor.equals("nil")) {
                return new JplNil(this.provider);
            }
            if (functor.equals("!")) {
                return new JplCut(this.createProvider());
            }
            if (functor.equals("fail")) {
                return new JplFail(this.provider);
            }
            if (functor.equals("true")) {
                return new JplTrue(this.provider);
            }
            if (functor.equals("false")) {
                return new JplFalse(this.provider);
            }
            if (functor.equals("[]")) {
                return new JplEmpty(this.provider);
            }
            return new JplAtom(this.provider, functor);
        }
        if (prologTerm.equals(JplList.EMPTY)) {
            return new JplEmpty(this.provider);
        }
        if (prologTerm.isFloat()) {
            return new JplFloat(this.provider, java.lang.Float.valueOf(((Float)prologTerm).floatValue()));
        }
        if (prologTerm.isInteger()) {
            try {
                return new JplInteger(this.provider, ((Integer)prologTerm).intValue());
            }
            catch (JPLException e) {
                return new JplLong(this.provider, ((Integer)prologTerm).longValue());
            }
        }
        if (prologTerm.isVariable()) {
            String name = ((Variable)prologTerm).name();
            PrologVariable variable = (PrologVariable)this.sharedVariables.get(name);
            if (variable == null) {
                variable = new JplVariable(this.provider, name);
                this.sharedVariables.put(variable.getName(), variable);
            }
            return variable;
        }
        if (prologTerm.hasFunctor(".", 2)) {
            Term[] a = new Term[]{};
            ArrayList<Term> l = new ArrayList<Term>();
            Term ptr = prologTerm;
            while (!ptr.isVariable() && ptr.hasFunctor(".", 2)) {
                l.add(ptr.arg(1));
                ptr = ptr.arg(2);
            }
            return new JplList(this.provider, l.toArray(a));
        }
        if (prologTerm.isCompound()) {
            Compound compound = (Compound)prologTerm;
            int arity = compound.arity();
            String functor = compound.name();
            Term[] arguments = new Term[arity];
            if (functor.equals("@") && arity == 1) {
                return new JplReference(this.provider, (Term)compound);
            }
            if (arity == 2) {
                String key = "LIST";
                String opQuery = "findall(OP,current_op(_,_,OP)," + key + ")";
                Query query = new Query(opQuery);
                if (query.hasSolution()) {
                    Term[] termArray;
                    Term term = (Term)query.oneSolution().get(key);
                    for (Term termArray1 : termArray = term.toTermArray()) {
                        if (!termArray1.name().equals(functor)) continue;
                        Term left = compound.arg(1);
                        Term right = compound.arg(2);
                        return new JplStructure(this.provider, left, functor, right);
                    }
                }
                query.close();
            }
            for (int i = 0; i < arity; ++i) {
                arguments[i] = compound.arg(i + 1);
            }
            return new JplStructure(this.provider, functor, arguments);
        }
        throw new UnknownTermError((Object)prologTerm);
    }

    public final Term fromTerm(PrologTerm term) {
        switch (term.getType()) {
            case 769: {
                return new Atom("nil");
            }
            case 772: {
                return new Atom("!");
            }
            case 773: {
                return new Atom("fail");
            }
            case 771: {
                return new Atom("true");
            }
            case 770: {
                return new Atom("false");
            }
            case 768: {
                return new Atom(this.removeQuoted(((PrologAtom)term).getStringValue()));
            }
            case 514: {
                return new Float((double)((PrologFloat)term).getFloatValue());
            }
            case 512: {
                return new Integer((long)((PrologInteger)term).getIntegerValue());
            }
            case 515: {
                return new Float(((PrologDouble)term).getDoubleValue());
            }
            case 513: {
                return new Integer(((PrologLong)term).getLongValue());
            }
            case 256: {
                String name = ((PrologVariable)term).getName();
                Term variable = (Term)this.sharedPrologVariables.get(name);
                if (variable == null) {
                    variable = new Variable(name);
                    this.sharedPrologVariables.put(name, variable);
                }
                return variable;
            }
            case 1281: 
            case 1284: {
                PrologTerm[] array = term.getArguments();
                Term list = JplEmpty.EMPTY;
                for (int i = array.length - 1; i >= 0; --i) {
                    list = new Compound(".", new Term[]{this.fromTerm(array[i]), list});
                }
                return list;
            }
            case 1282: 
            case 1283: {
                String functor = term.getFunctor();
                Term[] arguments = this.fromTermArray(((PrologStructure)term).getArguments());
                return new Compound(functor, arguments);
            }
            case 1024: {
                return JPL.newJRef((Object)term.getObject());
            }
            case 1288: 
            case 1290: 
            case 1291: {
                String name = ((PrologVariable)term).getName();
                Term variable = (Term)this.sharedPrologVariables.get(name);
                if (variable == null) {
                    variable = new Variable(name);
                    this.sharedPrologVariables.put(name, variable);
                }
                return variable;
            }
            case 1285: 
            case 1286: {
                String functor = this.removeQuoted(term.getFunctor());
                Term[] arguments = this.fromTermArray(term.getArguments());
                return new Compound(functor, arguments);
            }
        }
        throw new UnknownTermError((Object)term);
    }

    public final Term[] fromTermArray(PrologTerm[] terms) {
        Term[] prologTerms = new Term[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            prologTerms[i] = this.fromTerm(terms[i]);
        }
        return prologTerms;
    }

    public final Term fromTerm(PrologTerm head, PrologTerm[] body) {
        Term clauseHead = this.fromTerm(head);
        if (body != null && body.length > 0) {
            Term clauseBody = this.fromTerm(body[body.length - 1]);
            for (int i = body.length - 2; i >= 0; --i) {
                clauseBody = new Compound(",", new Term[]{this.fromTerm(body[i]), clauseBody});
            }
            return new Compound(":-", new Term[]{clauseHead, clauseBody});
        }
        return clauseHead;
    }
}

