/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog.jpl;

import io.github.prolobjectlink.prolog.AbstractEngine;
import io.github.prolobjectlink.prolog.ArrayIterator;
import io.github.prolobjectlink.prolog.PrologClause;
import io.github.prolobjectlink.prolog.PrologEngine;
import io.github.prolobjectlink.prolog.PrologIndicator;
import io.github.prolobjectlink.prolog.PrologOperator;
import io.github.prolobjectlink.prolog.PrologProgram;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologQuery;
import io.github.prolobjectlink.prolog.PrologTerm;
import io.github.prolobjectlink.prolog.jpl.JplClause;
import io.github.prolobjectlink.prolog.jpl.JplIndicator;
import io.github.prolobjectlink.prolog.jpl.JplOperator;
import io.github.prolobjectlink.prolog.jpl.JplParser;
import io.github.prolobjectlink.prolog.jpl.JplProgram;
import io.github.prolobjectlink.prolog.jpl.JplProvider;
import io.github.prolobjectlink.prolog.jpl.JplQuery;
import io.github.prolobjectlink.prolog.jpl.JplScript;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jpl.Atom;
import jpl.Query;
import jpl.Term;
import jpl.Util;

public abstract class JplEngine
extends AbstractEngine
implements PrologEngine {
    private static final String KEY = "X";
    private static final Term BODY = new Atom("true");
    private static String cache = null;
    private final JplParser parser = new JplParser();
    private JplProgram program = new JplProgram();
    private static String consultCacheComma;

    protected JplEngine(PrologProvider provider) {
        super(provider);
    }

    protected JplEngine(PrologProvider provider, String path) {
        super(provider);
        this.consult(path);
    }

    public final void consult(String path) {
        this.program = this.parser.parseProgram(path);
        this.persist(cache);
    }

    public final void consult(Reader reader) {
        this.program = this.parser.parseProgram(reader);
        this.persist(cache);
    }

    public final void include(String path) {
        this.program.add(this.parser.parseProgram(path));
        this.persist(cache);
    }

    public final void include(Reader reader) {
        this.program.add(this.parser.parseProgram(reader));
        this.persist(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void persist(String path) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileOutputStream(path, false));
            writer.print(this.program);
        }
        catch (FileNotFoundException e) {
            this.getLogger().error(((Object)((Object)this)).getClass(), (Object)("Some error occurs opening the file" + cache), (Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public final void abolish(String functor, int arity) {
        this.program.removeAll(functor, arity);
        this.persist(cache);
    }

    public final void asserta(String stringClause) {
        this.asserta(Util.textToTerm((String)stringClause));
    }

    public final void asserta(PrologTerm term) {
        this.asserta((Term)this.fromTerm(term, Term.class));
    }

    public final void asserta(PrologTerm head, PrologTerm ... body) {
        this.asserta((Term)this.fromTerm(head, body, Term.class));
    }

    private void asserta(Term t) {
        this.program.push(t);
        this.persist(cache);
    }

    public final void assertz(String stringClause) {
        this.assertz(Util.textToTerm((String)stringClause));
    }

    public final void assertz(PrologTerm term) {
        this.assertz((Term)this.fromTerm(term, Term.class));
    }

    public final void assertz(PrologTerm head, PrologTerm ... body) {
        this.assertz((Term)this.fromTerm(head, body, Term.class));
    }

    private void assertz(Term t) {
        this.program.add(t);
        this.persist(cache);
    }

    public final boolean clause(String stringClause) {
        return this.clause(Util.textToTerm((String)stringClause));
    }

    public final boolean clause(PrologTerm term) {
        return this.clause((Term)this.fromTerm(term, Term.class));
    }

    public final boolean clause(PrologTerm head, PrologTerm ... body) {
        return this.clause((Term)this.fromTerm(head, body, Term.class));
    }

    private boolean clause(Term t) {
        Term h = t;
        Term b = BODY;
        if (t.hasFunctor(":-", 2)) {
            h = t.arg(1);
            b = t.arg(2);
        }
        return new JplQuery(this, cache, "clause(" + h + "," + b + ")").hasSolution();
    }

    public final void retract(String stringClause) {
        this.retract(Util.textToTerm((String)stringClause));
    }

    public final void retract(PrologTerm term) {
        this.retract((Term)this.fromTerm(term, Term.class));
    }

    public final void retract(PrologTerm head, PrologTerm ... body) {
        this.retract((Term)this.provider.fromTerm(head, body, Term.class));
    }

    private void retract(Term t) {
        this.program.remove(t);
        this.persist(cache);
    }

    public final PrologQuery query(String stringQuery) {
        return new JplQuery(this, cache, stringQuery);
    }

    public final PrologQuery query(PrologTerm term) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("" + term + ".");
        return this.query("" + buffer + "");
    }

    public final PrologQuery query(PrologTerm[] terms) {
        ArrayIterator i = new ArrayIterator((Object[])terms);
        StringBuilder buffer = new StringBuilder();
        while (i.hasNext()) {
            buffer.append(i.next());
            if (!i.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append(".");
        return this.query("" + buffer + "");
    }

    public final PrologQuery query(PrologTerm term, PrologTerm ... terms) {
        ArrayIterator i = new ArrayIterator((Object[])terms);
        StringBuilder buffer = new StringBuilder();
        buffer.append("" + term + "");
        while (i.hasNext()) {
            buffer.append(',');
            buffer.append(i.next());
        }
        buffer.append(".");
        return this.query("" + buffer + "");
    }

    public final void operator(int priority, String specifier, String operator) {
        new Query(consultCacheComma + "op(" + priority + "," + specifier + ", " + operator + ")").hasSolution();
    }

    public final boolean currentPredicate(String functor, int arity) {
        String x = functor;
        if (x.startsWith("'") && x.endsWith("'")) {
            x = x.substring(1, x.length() - 1);
        }
        return this.getPredicates().contains((Object)new JplIndicator(x, arity));
    }

    public final boolean currentOperator(int priority, String specifier, String operator) {
        return new Query(consultCacheComma + "current_op(" + priority + "," + specifier + ", " + operator + ")").hasSolution();
    }

    public final Set<PrologOperator> currentOperators() {
        HashSet<PrologOperator> operators = new HashSet<PrologOperator>();
        String opQuery = consultCacheComma + "findall(P/S/O,current_op(P,S,O)," + KEY + ")";
        Query query = new Query(opQuery);
        if (query.hasSolution()) {
            Term[] termArray;
            Term term = (Term)query.oneSolution().get(KEY);
            for (Term t : termArray = term.toTermArray()) {
                Term prio = t.arg(1).arg(1);
                Term pos = t.arg(1).arg(2);
                Term op = t.arg(2);
                int p = prio.intValue();
                String s = pos.name();
                String n = op.name();
                JplOperator o = new JplOperator(p, s, n);
                operators.add(o);
            }
        }
        query.close();
        return operators;
    }

    public final int getProgramSize() {
        return this.program.size();
    }

    public final PrologProgram getProgram() {
        return new JplScript(this);
    }

    public final Set<PrologIndicator> getPredicates() {
        HashSet<PrologIndicator> indicators = new HashSet<PrologIndicator>();
        String opQuery = consultCacheComma + "findall(X/Y,current_predicate(X/Y)," + KEY + ")";
        Query query = new Query(opQuery);
        if (query.hasSolution()) {
            Term[] termArray;
            Term term = (Term)query.oneSolution().get(KEY);
            for (Term t : termArray = term.toTermArray()) {
                Term f = t.arg(1);
                Term a = t.arg(2);
                int arity = a.intValue();
                String functor = f.name();
                JplIndicator pi = new JplIndicator(functor, arity);
                indicators.add(pi);
            }
        }
        return indicators;
    }

    public final Set<PrologIndicator> getBuiltIns() {
        Set<PrologIndicator> pis = this.predicates();
        Set clauses = this.getProgramClauses();
        for (PrologClause prologClause : clauses) {
            PrologIndicator pi = prologClause.getPrologIndicator();
            if (!pis.contains(pi)) continue;
            pis.remove(pi);
        }
        return pis;
    }

    private Set<PrologIndicator> predicates() {
        HashSet<PrologIndicator> indicators = new HashSet<PrologIndicator>();
        String stringQuery = "consult('" + cache + "'),findall(X/Y,current_predicate(X/Y)," + KEY + ")";
        JplQuery query = new JplQuery(this, cache, stringQuery);
        if (query.hasSolution()) {
            Map[] s;
            for (Map map : s = query.allVariablesSolutions()) {
                for (PrologTerm term : map.values()) {
                    if (!term.isCompound()) continue;
                    int arity = term.getArity();
                    String functor = term.getFunctor();
                    JplIndicator pi = new JplIndicator(functor, arity);
                    indicators.add(pi);
                }
            }
        }
        return indicators;
    }

    public final Iterator<PrologClause> iterator() {
        ArrayList<JplClause> cls = new ArrayList<JplClause>();
        for (List<Term> family : this.program.getClauses().values()) {
            for (Term clause : family) {
                if (clause.hasFunctor(":-", 2)) {
                    PrologTerm head = this.toTerm(clause.arg(1), PrologTerm.class);
                    PrologTerm body = this.toTerm(clause.arg(2), PrologTerm.class);
                    if (body.getType() != 771) {
                        cls.add(new JplClause(this.provider, head, body, false, false, false));
                        continue;
                    }
                    cls.add(new JplClause(this.provider, head, false, false, false));
                    continue;
                }
                cls.add(new JplClause(this.provider, this.toTerm(clause, PrologTerm.class), false, false, false));
            }
        }
        return new AbstractEngine.PrologProgramIterator((AbstractEngine)this, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        File c = new File(cache);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileOutputStream(cache, false));
            writer.print("");
        }
        catch (FileNotFoundException e) {
            this.getLogger().error(((Object)((Object)this)).getClass(), (Object)("Some error occurs opening the file" + cache), (Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        c.deleteOnExit();
        this.program.clear();
    }

    public final String getCache() {
        return cache;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.program == null ? 0 : this.program.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        JplEngine other = (JplEngine)((Object)obj);
        return !(this.program == null ? other.program != null : !this.program.equals(other.program));
    }

    static {
        try {
            File f = File.createTempFile("prolobjectlink-jpi-jpl-cache-", ".pl");
            cache = f.getCanonicalPath().replace(File.separatorChar, '/');
            consultCacheComma = "consult('" + cache + "'),";
        }
        catch (IOException e) {
            JplProvider.logger.error(JplEngine.class, (Object)"Some error occurs opening the file", (Throwable)e);
        }
    }
}

