/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog.jpl;

import io.github.prolobjectlink.prolog.AbstractIterator;
import io.github.prolobjectlink.prolog.PrologList;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologTerm;
import io.github.prolobjectlink.prolog.jpl.JplTerm;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jpl.Atom;
import jpl.Compound;
import jpl.Term;

public class JplList
extends JplTerm
implements PrologList {
    public static final Term EMPTY = new Atom("[]");

    protected JplList(PrologProvider provider) {
        super(1281, provider, EMPTY);
    }

    protected JplList(PrologProvider provider, Term[] arguments) {
        super(1281, provider);
        this.value = EMPTY;
        for (int i = arguments.length - 1; i >= 0; --i) {
            this.value = new Compound(".", new Term[]{arguments[i], this.value});
        }
    }

    protected JplList(PrologProvider provider, PrologTerm[] arguments) {
        super(1281, provider);
        this.value = EMPTY;
        for (int i = arguments.length - 1; i >= 0; --i) {
            this.value = new Compound(".", new Term[]{((JplTerm)arguments[i]).value, this.value});
        }
    }

    protected JplList(PrologProvider provider, PrologTerm head, PrologTerm tail) {
        super(1281, provider);
        Term h = ((JplTerm)head).value;
        Term t = ((JplTerm)tail).value;
        this.value = new Compound(".", new Term[]{h, t});
    }

    protected JplList(PrologProvider provider, PrologTerm[] arguments, PrologTerm tail) {
        super(1281, provider);
        this.value = (Term)this.fromTerm(tail, Term.class);
        for (int i = arguments.length - 1; i >= 0; --i) {
            Term[] args = new Term[]{(Term)this.fromTerm(arguments[i], Term.class), this.value};
            this.value = new Compound(".", args);
        }
    }

    public int size() {
        return ((Compound)this.value).listLength();
    }

    public void clear() {
        this.value = EMPTY;
    }

    public boolean isEmpty() {
        return this.value.equals(EMPTY);
    }

    public Iterator<PrologTerm> iterator() {
        return new SwiPrologListIter(this.value);
    }

    public PrologTerm getHead() {
        Compound list = (Compound)this.value;
        return this.provider.toTerm((Object)list.arg(1), PrologTerm.class);
    }

    public PrologTerm getTail() {
        Compound list = (Compound)this.value;
        return this.provider.toTerm((Object)list.arg(2), PrologTerm.class);
    }

    public int getArity() {
        return this.value.arity();
    }

    public String getFunctor() {
        return ".";
    }

    public PrologTerm[] getArguments() {
        return this.toTermArray(this.value.toTermArray(), PrologTerm[].class);
    }

    @Override
    public String toString() {
        StringBuilder string = new StringBuilder("[");
        Iterator<PrologTerm> i = this.iterator();
        if (i.hasNext()) {
            string.append(i.next());
        }
        while (i.hasNext()) {
            string.append(", ");
            string.append(i.next());
        }
        return string.append("]").toString();
    }

    private class SwiPrologListIter
    extends AbstractIterator<PrologTerm>
    implements Iterator<PrologTerm> {
        private Term ptr;
        private int index;
        private int length;

        private SwiPrologListIter(Term l) {
            this.ptr = l;
            if (l.hasFunctor(".", 2)) {
                this.length = l.listLength();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public PrologTerm next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            PrologTerm term = JplList.this.toTerm(this.ptr.arg(1), PrologTerm.class);
            this.ptr = this.ptr.arg(2);
            ++this.index;
            return term;
        }
    }
}

