/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog.jpl;

import io.github.prolobjectlink.prolog.AbstractLogger;
import io.github.prolobjectlink.prolog.PrologLogger;
import io.github.prolobjectlink.prolog.jpl.JplFormatter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

final class JplLogger
extends AbstractLogger
implements PrologLogger {
    private static final String MESSAGE = "Logger File Handler can't be created";
    private static final Logger LOGGER = Logger.getLogger("global");

    public JplLogger() {
        this(Level.INFO);
    }

    private JplLogger(Level level) {
        LOGGER.setLevel(level);
        Logger rootlogger = LOGGER.getParent();
        SimpleDateFormat f = new SimpleDateFormat("yyyy.MM.dd");
        String date = f.format(new Date());
        JplFormatter formatter = new JplFormatter();
        for (Handler h : rootlogger.getHandlers()) {
            h.setFormatter(formatter);
            h.setLevel(level);
        }
        Handler file = null;
        try {
            file = new FileHandler("%t/prolobjectlink-" + date + ".log", true);
        }
        catch (SecurityException e) {
            rootlogger.log(Level.SEVERE, MESSAGE, e);
        }
        catch (IOException e) {
            rootlogger.log(Level.SEVERE, MESSAGE, e);
        }
        assert (file != null);
        file.setFormatter(formatter);
        LOGGER.addHandler(file);
    }

    public void log(Object sender, Level level, Object message, Throwable throwable) {
        LOGGER.log(level, sender + "\n" + message, throwable);
    }
}

