/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog.jpl;

import io.github.prolobjectlink.prolog.ArrayIterator;
import io.github.prolobjectlink.prolog.PrologClauses;
import io.github.prolobjectlink.prolog.PrologError;
import io.github.prolobjectlink.prolog.jpl.JplParser;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jpl.Term;

final class JplProgram
extends AbstractSet<List<Term>> {
    private final JplParser parser = new JplParser();
    private final List<Term> goals = new LinkedList<Term>();
    private final List<Term> directives = new LinkedList<Term>();
    private final LinkedHashMap<String, List<Term>> clauses = new LinkedHashMap();

    JplProgram() {
    }

    private String getKey(Term clause) {
        String key = clause.name();
        if ((key = key + "/" + clause.arity()).equals(":-/2")) {
            key = clause.arg(1).name();
            key = key + "/";
            key = key + clause.arg(1).arity();
        }
        return key;
    }

    private String getKey(List<Term> cls) {
        String msg = "Empty clause list";
        if (!cls.isEmpty()) {
            Term t = cls.get(0);
            String key = t.name();
            key = key + "/" + t.arity();
            return key;
        }
        throw new PrologError(msg);
    }

    public List<Term> get(String key) {
        return this.clauses.get(key);
    }

    public void add(Term clause) {
        String key = this.getKey(clause);
        List<Term> family = this.get(key);
        if (family == null) {
            family = new LinkedList<Term>();
            family.add(clause);
            this.clauses.put(key, family);
        } else if (!family.contains(clause)) {
            family.add(clause);
        }
    }

    @Override
    public boolean add(List<Term> cls) {
        String key = this.getKey(cls);
        List<Term> family = this.get(key);
        if (family != null) {
            family.addAll(cls);
        } else {
            this.clauses.put(key, cls);
        }
        return true;
    }

    public void add(JplProgram program) {
        this.goals.addAll(program.getGoals());
        this.clauses.putAll(program.getClauses());
        this.directives.addAll(program.getDirectives());
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Term) {
            Term c = (Term)o;
            String key = this.getKey(c);
            List<Term> family = this.get(key);
            if (family != null) {
                return family.remove(c);
            }
        } else if (o instanceof PrologClauses) {
            PrologClauses cs = (PrologClauses)o;
            String key = cs.getIndicator();
            List oldFamily = (List)this.clauses.remove(key);
            return oldFamily != null;
        }
        return false;
    }

    public boolean remove(Term o) {
        String key;
        List<Term> family;
        if (o instanceof Term && (family = this.get(key = this.getKey(o))) != null) {
            return family.remove(o);
        }
        return false;
    }

    public void push(Term clause) {
        String key = this.getKey(clause);
        List family = (List)this.clauses.remove(key);
        LinkedList<Term> cs = new LinkedList<Term>();
        if (family != null && !family.contains(clause)) {
            cs.add(clause);
            for (Term term : family) {
                cs.add(term);
            }
        } else {
            cs.add(clause);
        }
        this.clauses.put(key, cs);
    }

    public void removeAll(String key) {
        this.clauses.remove(key);
    }

    public void removeAll(String functor, int arity) {
        this.removeAll(functor + "/" + arity);
    }

    public List<Term> getDirectives() {
        return this.directives;
    }

    public boolean addDirective(Term directive) {
        return this.directives.add(directive);
    }

    public boolean removeDirective(Term directive) {
        return this.directives.remove(directive);
    }

    public List<Term> getGoals() {
        return this.goals;
    }

    public boolean addGoal(Term goal) {
        return this.goals.add(goal);
    }

    public boolean removeGoal(Term goal) {
        return this.goals.remove(goal);
    }

    public Set<String> getIndicators() {
        return this.clauses.keySet();
    }

    public Map<String, List<Term>> getClauses() {
        return this.clauses;
    }

    @Override
    public String toString() {
        Iterator<Object> i;
        StringBuilder families = new StringBuilder();
        if (!this.directives.isEmpty()) {
            i = this.directives.iterator();
            while (i.hasNext()) {
                families.append(":-");
                families.append(i.next());
                families.append('.');
                families.append(i.hasNext() ? "\n" : "\n\n");
            }
        }
        if (!this.clauses.isEmpty()) {
            i = this.iterator();
            while (i.hasNext()) {
                List l = (List)i.next();
                for (Term term : l) {
                    String key = term.name();
                    key = key + "/" + term.arity();
                    if (term.arity() == 2 && key.equals(":-/2")) {
                        Term h = term.arg(1);
                        Term b = term.arg(2);
                        families.append(h);
                        families.append(" :- ");
                        families.append('\n');
                        families.append('\t');
                        Object[] array = this.parser.parseTerms(b);
                        ArrayIterator k = new ArrayIterator(array);
                        while (k.hasNext()) {
                            Term item = (Term)k.next();
                            families.append(item);
                            if (!k.hasNext()) continue;
                            families.append(',');
                            families.append('\n');
                            families.append('\t');
                        }
                    } else {
                        families.append(term);
                    }
                    families.append('.');
                    families.append('\n');
                }
                if (!i.hasNext()) continue;
                families.append('\n');
            }
        }
        return "" + families + "";
    }

    @Override
    public Iterator<List<Term>> iterator() {
        return this.clauses.values().iterator();
    }

    @Override
    public int size() {
        int size = 0;
        for (List<Term> l : this) {
            Iterator<Term> j = l.iterator();
            while (j.hasNext()) {
                j.next();
                ++size;
            }
        }
        return size;
    }

    @Override
    public void clear() {
        this.goals.clear();
        this.clauses.clear();
        this.directives.clear();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.clauses.hashCode();
        result = 31 * result + this.directives.hashCode();
        result = 31 * result + this.goals.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JplProgram other = (JplProgram)obj;
        if (!this.clauses.equals(other.clauses)) {
            return false;
        }
        if (!this.directives.equals(other.directives)) {
            return false;
        }
        return this.goals.equals(other.goals);
    }
}

