/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog.jpl;

import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologStructure;
import io.github.prolobjectlink.prolog.PrologTerm;
import io.github.prolobjectlink.prolog.jpl.JplTerm;
import jpl.Compound;
import jpl.Term;

class JplStructure
extends JplTerm
implements PrologStructure {
    JplStructure(PrologProvider provider, String functor, PrologTerm ... arguments) {
        super(1282, provider);
        Term[] terms = new Term[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            terms[i] = ((JplTerm)arguments[i]).value;
        }
        this.value = new Compound(this.removeQuoted(functor), terms);
    }

    JplStructure(PrologProvider provider, String functor, Term ... arguments) {
        super(1282, provider);
        this.value = new Compound(this.removeQuoted(functor), arguments);
    }

    JplStructure(PrologProvider provider, PrologTerm left, String operator, PrologTerm right) {
        super(1282, provider);
        Term leftOperand = ((JplTerm)left).value;
        Term rightOperand = ((JplTerm)right).value;
        this.value = new Compound(operator, new Term[]{leftOperand, rightOperand});
    }

    JplStructure(PrologProvider provider, Term left, String functor, Term right) {
        super(1282, provider, (Term)new Compound(functor, new Term[]{left, right}));
    }

    JplStructure(int objectType, PrologProvider provider, Term newJRef) {
        super(objectType, provider, newJRef);
    }

    public PrologTerm getArgument(int index) {
        this.checkIndex(index, this.getArity());
        return this.getArguments()[index];
    }

    public PrologTerm[] getArguments() {
        Compound structure = (Compound)this.value;
        int arity = structure.arity();
        PrologTerm[] arguments = new PrologTerm[arity];
        for (int i = 0; i < arity; ++i) {
            arguments[i] = this.toTerm(structure.arg(i + 1), PrologTerm.class);
        }
        return arguments;
    }

    public int getArity() {
        Compound structure = (Compound)this.value;
        return structure.arity();
    }

    public String getFunctor() {
        Compound structure = (Compound)this.value;
        return structure.name();
    }

    public final PrologTerm getRight() {
        return this.getArgument(1);
    }

    public final PrologTerm getLeft() {
        return this.getArgument(0);
    }

    public final String getOperator() {
        return this.getFunctor();
    }
}

