/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog.jpl7;

import io.github.prolobjectlink.prolog.PrologFormatter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

final class JplFormatter
extends Formatter
implements PrologFormatter {
    private static final String ERROR = "ERROR";
    private static final String WARN = "WARN";
    private static final String INFO = "INFO";
    private static final String DEBUG = "DEBUG";
    private static final String TRACE = "TRACE";

    JplFormatter() {
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder buffer = new StringBuilder();
        String levelString = "";
        Level level = record.getLevel();
        if (level.intValue() == Level.SEVERE.intValue()) {
            levelString = ERROR;
        } else if (level.intValue() == Level.WARNING.intValue()) {
            levelString = WARN;
        } else if (level.intValue() == Level.INFO.intValue()) {
            levelString = INFO;
        } else if (level.intValue() == Level.CONFIG.intValue()) {
            levelString = DEBUG;
        } else if (level.intValue() == Level.FINE.intValue()) {
            levelString = DEBUG;
        } else if (level.intValue() == Level.FINER.intValue()) {
            levelString = DEBUG;
        } else if (level.intValue() == Level.FINEST.intValue()) {
            levelString = TRACE;
        }
        long millisecs = record.getMillis();
        String name = record.getLoggerName();
        String message = record.getMessage();
        Throwable throwable = record.getThrown();
        SimpleDateFormat f = new SimpleDateFormat("MMM-dd-yyyy HH:mm");
        Date resultdate = new Date(millisecs);
        String date = f.format(resultdate);
        buffer.append('[');
        buffer.append(name);
        buffer.append(']');
        buffer.append(' ');
        buffer.append(levelString);
        buffer.append(' ');
        buffer.append(date);
        buffer.append(' ');
        buffer.append(message);
        if (throwable != null) {
            StackTraceElement[] s;
            buffer.append('\n');
            buffer.append(throwable);
            buffer.append('\n');
            for (StackTraceElement stackTraceElement : s = throwable.getStackTrace()) {
                buffer.append(stackTraceElement);
                buffer.append('\n');
            }
        }
        buffer.append('\n');
        return "" + buffer + "";
    }
}

