/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog.jpl7;

import io.github.prolobjectlink.prolog.AbstractCompounds;
import io.github.prolobjectlink.prolog.AbstractIterator;
import io.github.prolobjectlink.prolog.PrologMap;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologTerm;
import io.github.prolobjectlink.prolog.jpl7.JplEntry;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class JplMap
extends AbstractCompounds
implements PrologMap {
    private Map<PrologTerm, PrologTerm> map;

    JplMap(PrologProvider provider, int size) {
        super(1284, provider);
        this.map = new LinkedHashMap<PrologTerm, PrologTerm>(size);
    }

    JplMap(PrologProvider provider, Map<? extends PrologTerm, ? extends PrologTerm> m) {
        this(provider);
        this.putAll(m);
    }

    JplMap(PrologProvider provider) {
        this(provider, 16);
    }

    public boolean isList() {
        return true;
    }

    public boolean isStructure() {
        return false;
    }

    public boolean isEmptyList() {
        return this.map.size() == 0;
    }

    public String getFunctor() {
        return ".";
    }

    public int getArity() {
        if (this.map.size() > 0) {
            return 2;
        }
        return 0;
    }

    public PrologTerm[] getArguments() {
        PrologProvider p = this.getProvider();
        PrologTerm[] args = new PrologTerm[this.map.size()];
        Set<Map.Entry<PrologTerm, PrologTerm>> s = this.entrySet();
        Iterator<Map.Entry<PrologTerm, PrologTerm>> i = s.iterator();
        for (int j = 0; j < args.length && i.hasNext(); ++j) {
            Map.Entry<PrologTerm, PrologTerm> e = i.next();
            args[j] = new JplEntry(p, e.getKey(), e.getValue());
        }
        return args;
    }

    public PrologTerm getArgument(int index) {
        PrologTerm term = null;
        this.checkIndex(index, this.size());
        Iterator<PrologTerm> i = this.iterator();
        for (int idx = 0; i.hasNext() && idx <= index; ++idx) {
            term = i.next();
            if (idx != index) continue;
            return term;
        }
        return term;
    }

    public int hashCode() {
        int result = 0;
        int prime = 31;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        JplMap other = (JplMap)((Object)obj);
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        Set<Map.Entry<PrologTerm, PrologTerm>> set = this.entrySet();
        Iterator<Map.Entry<PrologTerm, PrologTerm>> i = set.iterator();
        b.append('[');
        while (i.hasNext()) {
            Map.Entry<PrologTerm, PrologTerm> entry = i.next();
            b.append(entry.getKey());
            b.append('-');
            b.append(entry.getValue());
            if (!i.hasNext()) continue;
            b.append(',');
            b.append(' ');
        }
        b.append(']');
        return "" + b + "";
    }

    public Iterator<PrologTerm> iterator() {
        return new PrologMapIterator();
    }

    public PrologTerm getHead() {
        return this.iterator().next();
    }

    public PrologTerm getTail() {
        JplMap m = new JplMap(this.provider, this.map);
        m.remove(((Map.Entry)this.getHead()).getKey());
        return m;
    }

    public void putAll(Collection<Map.Entry<PrologTerm, PrologTerm>> entries) {
        for (Map.Entry<PrologTerm, PrologTerm> entry : entries) {
            this.put(entry);
        }
    }

    public boolean contains(Map.Entry<PrologTerm, PrologTerm> entry) {
        PrologTerm value = this.get(entry.getKey());
        return value != null ? value.equals(entry.getValue()) : false;
    }

    public void remove(Map.Entry<PrologTerm, PrologTerm> entry) {
        this.remove(entry.getKey());
    }

    public void put(Map.Entry<PrologTerm, PrologTerm> entry) {
        this.put(entry.getKey(), entry.getValue());
    }

    public PrologTerm put(PrologTerm key, PrologTerm value) {
        return this.map.put(key, value);
    }

    public Set<Map.Entry<PrologTerm, PrologTerm>> entrySet() {
        return this.map.entrySet();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public PrologTerm get(Object key) {
        return this.map.get(key);
    }

    public PrologTerm remove(Object key) {
        return this.map.remove(key);
    }

    public void putAll(Map<? extends PrologTerm, ? extends PrologTerm> m) {
        this.map.putAll(m);
    }

    public Set<PrologTerm> keySet() {
        return this.map.keySet();
    }

    public Collection<PrologTerm> values() {
        return this.map.values();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    private class PrologMapIterator
    extends AbstractIterator<PrologTerm>
    implements Iterator<PrologTerm> {
        private final Set<PrologTerm> set;
        private final Iterator<PrologTerm> itr;

        private PrologMapIterator() {
            this.set = new LinkedHashSet<PrologTerm>(JplMap.this.map.size());
            for (Map.Entry e : JplMap.this.map.entrySet()) {
                JplEntry t = new JplEntry(JplMap.this.provider, (PrologTerm)e.getKey(), (PrologTerm)e.getValue());
                this.set.add((PrologTerm)t);
            }
            this.itr = this.set.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public PrologTerm next() {
            return this.itr.next();
        }
    }
}

