/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog.jpl7;

import io.github.prolobjectlink.prolog.jpl7.JplProgram;
import io.github.prolobjectlink.prolog.jpl7.JplProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.jpl7.Atom;
import org.jpl7.Compound;
import org.jpl7.Term;
import org.jpl7.Util;

final class JplParser {
    JplParser() {
    }

    public Term parseTerm(String term) {
        return Util.textToTerm((String)term);
    }

    public Term[] parseTerms(Term term) {
        return this.parseTerms("" + term + "");
    }

    public Term[] parseTerms(String stringTerms) {
        Term[] a = new Term[]{};
        Term ptr = Util.textToTerm((String)stringTerms);
        ArrayList<Term> terms = new ArrayList<Term>();
        while (ptr.isCompound() && ptr.hasFunctor(",", 2)) {
            terms.add(ptr.arg(1));
            ptr = ptr.arg(2);
        }
        terms.add(ptr);
        return terms.toArray(a);
    }

    public JplProgram parseProgram(String file) {
        return this.parseProgram(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JplProgram parseProgram(File in) {
        FileReader reader = null;
        BufferedReader buffer = null;
        JplProgram program = new JplProgram();
        try {
            reader = new FileReader(in);
            buffer = new BufferedReader(reader);
            String line = buffer.readLine();
            StringBuilder b = new StringBuilder();
            while (line != null) {
                if (!line.isEmpty() && line.lastIndexOf(46) == line.length() - 1) {
                    b.append(line.substring(0, line.length() - 1));
                    Term clauseTerm = Util.textToTerm((String)("" + b + ""));
                    if (clauseTerm.hasFunctor(":-", 1)) {
                        String absoluteString = "";
                        Term arg = clauseTerm.arg(1);
                        if (arg.hasFunctor("consult", 1)) {
                            Term relative = arg.arg(1);
                            String path = relative.name();
                            String[] array = path.split("\\.\\./");
                            if (array.length > 1) {
                                String ok = array[array.length - 1];
                                File currentPtr = in.getCanonicalFile();
                                for (int i = 0; i < array.length; ++i) {
                                    currentPtr = currentPtr.getParentFile();
                                }
                                String ptr = currentPtr.getCanonicalPath();
                                File abs = new File(ptr + File.separator + ok);
                                absoluteString = abs.getCanonicalPath();
                            }
                            Atom absolute = new Atom(absoluteString.toLowerCase().replace(File.separatorChar, '/'));
                            Compound c = new Compound("consult", new Term[]{absolute});
                            program.addDirective((Term)c);
                        } else {
                            program.addDirective(clauseTerm);
                        }
                    } else {
                        program.add(clauseTerm);
                    }
                    b = new StringBuilder();
                } else {
                    b.append(line);
                }
                line = buffer.readLine();
            }
        }
        catch (FileNotFoundException e) {
            JplProvider.logger.error(this.getClass(), (Object)"File not found ", (Throwable)e);
        }
        catch (IOException e) {
            JplProvider.logger.error(this.getClass(), (Object)"Some error occurs opening the file", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    JplProvider.logger.error(this.getClass(), (Object)"Some error occurs opening the file", (Throwable)e);
                }
            }
            if (buffer != null) {
                try {
                    buffer.close();
                }
                catch (IOException e) {
                    JplProvider.logger.error(this.getClass(), (Object)"Some error occurs opening the file", (Throwable)e);
                }
            }
        }
        return program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JplProgram parseProgram(Reader in) {
        BufferedReader buffer = null;
        JplProgram program = new JplProgram();
        try {
            buffer = new BufferedReader(in);
            String line = buffer.readLine();
            StringBuilder b = new StringBuilder();
            while (line != null) {
                if (!line.isEmpty() && line.lastIndexOf(46) == line.length() - 1) {
                    b.append(line.substring(0, line.length() - 1));
                    Term clauseTerm = Util.textToTerm((String)("" + b + ""));
                    program.add(clauseTerm);
                    b = new StringBuilder();
                } else {
                    b.append(line);
                }
                line = buffer.readLine();
            }
        }
        catch (IOException e) {
            JplProvider.logger.error(this.getClass(), (Object)"Some error occurs opening the file", (Throwable)e);
        }
        finally {
            if (buffer != null) {
                try {
                    buffer.close();
                }
                catch (IOException e) {
                    JplProvider.logger.error(this.getClass(), (Object)"Some error occurs opening the file", (Throwable)e);
                }
            }
        }
        return program;
    }
}

