/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog.jpl7;

import io.github.prolobjectlink.prolog.AbstractProvider;
import io.github.prolobjectlink.prolog.PrologAtom;
import io.github.prolobjectlink.prolog.PrologConverter;
import io.github.prolobjectlink.prolog.PrologDouble;
import io.github.prolobjectlink.prolog.PrologFloat;
import io.github.prolobjectlink.prolog.PrologInteger;
import io.github.prolobjectlink.prolog.PrologJavaConverter;
import io.github.prolobjectlink.prolog.PrologList;
import io.github.prolobjectlink.prolog.PrologLogger;
import io.github.prolobjectlink.prolog.PrologLong;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologStructure;
import io.github.prolobjectlink.prolog.PrologTerm;
import io.github.prolobjectlink.prolog.PrologVariable;
import io.github.prolobjectlink.prolog.jpl7.JplAtom;
import io.github.prolobjectlink.prolog.jpl7.JplCut;
import io.github.prolobjectlink.prolog.jpl7.JplDouble;
import io.github.prolobjectlink.prolog.jpl7.JplEmpty;
import io.github.prolobjectlink.prolog.jpl7.JplEntry;
import io.github.prolobjectlink.prolog.jpl7.JplFail;
import io.github.prolobjectlink.prolog.jpl7.JplFalse;
import io.github.prolobjectlink.prolog.jpl7.JplFloat;
import io.github.prolobjectlink.prolog.jpl7.JplInteger;
import io.github.prolobjectlink.prolog.jpl7.JplList;
import io.github.prolobjectlink.prolog.jpl7.JplLogger;
import io.github.prolobjectlink.prolog.jpl7.JplLong;
import io.github.prolobjectlink.prolog.jpl7.JplMap;
import io.github.prolobjectlink.prolog.jpl7.JplNil;
import io.github.prolobjectlink.prolog.jpl7.JplReference;
import io.github.prolobjectlink.prolog.jpl7.JplStructure;
import io.github.prolobjectlink.prolog.jpl7.JplTrue;
import io.github.prolobjectlink.prolog.jpl7.JplVariable;
import java.util.ArrayList;
import java.util.Map;
import org.jpl7.JPL;
import org.jpl7.Term;
import org.jpl7.Util;

public abstract class JplProvider
extends AbstractProvider
implements PrologProvider {
    static final PrologLogger logger = new JplLogger();

    protected JplProvider(PrologConverter<Term> adapter) {
        super(adapter);
    }

    public final PrologTerm prologNil() {
        return new JplNil(this);
    }

    public final PrologTerm prologCut() {
        return new JplCut(this);
    }

    public final PrologTerm prologFail() {
        return new JplFail(this);
    }

    public final PrologTerm prologTrue() {
        return new JplTrue(this);
    }

    public final PrologTerm prologFalse() {
        return new JplFalse(this);
    }

    public final PrologTerm prologEmpty() {
        return new JplEmpty(this);
    }

    public final PrologTerm prologInclude(String file) {
        return this.newStructure("consult", new PrologTerm[]{this.newAtom(file)});
    }

    public final PrologTerm parseTerm(String term) {
        return this.toTerm(Util.textToTerm((String)term), PrologTerm.class);
    }

    public final PrologTerm[] parseTerms(String stringTerms) {
        PrologTerm[] a = new PrologTerm[]{};
        Term ptr = Util.textToTerm((String)stringTerms);
        ArrayList<PrologTerm> terms = new ArrayList<PrologTerm>();
        while (ptr.isCompound() && ptr.hasFunctor(",", 2)) {
            terms.add(this.toTerm(ptr.arg(1), PrologTerm.class));
            ptr = ptr.arg(2);
        }
        terms.add(this.toTerm(ptr, PrologTerm.class));
        return terms.toArray(a);
    }

    public final PrologAtom newAtom(String functor) {
        return new JplAtom(this, functor);
    }

    public final PrologFloat newFloat(Number value) {
        return new JplFloat(this, value);
    }

    public final PrologDouble newDouble(Number value) {
        return new JplDouble(this, value);
    }

    public final PrologInteger newInteger(Number value) {
        return new JplInteger(this, value);
    }

    public final PrologLong newLong(Number value) {
        return new JplLong(this, value);
    }

    public final PrologVariable newVariable(int position) {
        return new JplVariable(this);
    }

    public final PrologVariable newVariable(String name, int position) {
        return new JplVariable(this, name);
    }

    public final PrologList newList() {
        return new JplList(this);
    }

    public final PrologList newList(PrologTerm[] arguments) {
        return new JplList((PrologProvider)this, arguments);
    }

    public final PrologList newList(PrologTerm head, PrologTerm tail) {
        return new JplList((PrologProvider)this, head, tail);
    }

    public final PrologList newList(PrologTerm[] arguments, PrologTerm tail) {
        return new JplList((PrologProvider)this, arguments, tail);
    }

    public final PrologStructure newStructure(String functor, PrologTerm ... arguments) {
        return new JplStructure((PrologProvider)this, functor, arguments);
    }

    public final PrologTerm newStructure(PrologTerm left, String operator, PrologTerm right) {
        return new JplStructure((PrologProvider)this, left, operator, right);
    }

    public final PrologTerm newEntry(PrologTerm key, PrologTerm value) {
        return new JplEntry(this, key, value);
    }

    public final PrologTerm newEntry(Object key, Object value) {
        PrologJavaConverter transformer = this.getJavaConverter();
        PrologTerm keyTerm = transformer.toTerm(key);
        PrologTerm valueTerm = transformer.toTerm(value);
        return new JplEntry(this, keyTerm, valueTerm);
    }

    public final PrologTerm newMap(Map<PrologTerm, PrologTerm> map) {
        return new JplMap((PrologProvider)this, map);
    }

    public final PrologTerm newMap(int initialCapacity) {
        return new JplMap((PrologProvider)this, initialCapacity);
    }

    public final PrologTerm newMap() {
        return new JplMap(this);
    }

    public final PrologTerm newReference(Object reference) {
        return new JplReference((PrologProvider)this, reference);
    }

    public final PrologTerm falseReference() {
        return new JplReference((PrologProvider)this, JPL.JFALSE);
    }

    public final PrologTerm trueReference() {
        return new JplReference((PrologProvider)this, JPL.JTRUE);
    }

    public final PrologTerm nullReference() {
        return new JplReference((PrologProvider)this, JPL.JNULL);
    }

    public final PrologTerm voidReference() {
        return new JplReference((PrologProvider)this, JPL.JVOID);
    }

    public final PrologLogger getLogger() {
        return logger;
    }
}

