/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog.jpl7;

import io.github.prolobjectlink.prolog.AbstractEngine;
import io.github.prolobjectlink.prolog.AbstractIterator;
import io.github.prolobjectlink.prolog.AbstractQuery;
import io.github.prolobjectlink.prolog.PrologError;
import io.github.prolobjectlink.prolog.PrologQuery;
import io.github.prolobjectlink.prolog.PrologTerm;
import io.github.prolobjectlink.prolog.jpl7.JplReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jpl7.PrologException;
import org.jpl7.Query;
import org.jpl7.Term;
import org.jpl7.Util;
import org.jpl7.Variable;

final class JplQuery
extends AbstractQuery
implements PrologQuery {
    private String stringQuery;
    private Map<String, PrologTerm>[] solutions;
    private Iterator<Map<String, PrologTerm>> iter;
    private final List<String> variables;

    private void enumerateVariables(List<String> vector, Term term) {
        if (!(term instanceof Variable)) {
            Term[] terms;
            for (Term t : terms = term.args()) {
                this.enumerateVariables(vector, t);
            }
        } else if (!vector.contains(term.name())) {
            vector.add(term.name());
        }
    }

    JplQuery(AbstractEngine engine, String file, String stringQuery) {
        block3: {
            super(engine);
            this.variables = new ArrayList<String>();
            if (stringQuery != null && stringQuery.length() > 0) {
                this.stringQuery = stringQuery;
                this.enumerateVariables(this.variables, Util.textToTerm((String)stringQuery));
                try {
                    Query.hasSolution((String)("consult('" + file + "')"));
                    Query query = new Query(stringQuery);
                    Map[] solve = query.allSolutions();
                    this.solutions = this.toTermMapArray(solve, PrologTerm.class);
                    this.iter = new JplQueryIter(this.solutions);
                }
                catch (PrologException e) {
                    Object object;
                    HashMap<String, JplReference> m = new HashMap<String, JplReference>();
                    JplReference prologexception = new JplReference(this.getProvider(), (Object)e);
                    Term error = e.term();
                    Term exception = error.arg(1);
                    Term ref = exception.arg(1);
                    if (!ref.isJRef() || !((object = ref.object()) instanceof Throwable)) break block3;
                    Throwable k = (Throwable)object;
                    JplReference javaexception = new JplReference(this.getProvider(), k);
                    m.put("PrologException", prologexception);
                    m.put("JavaException", javaexception);
                    this.solutions = new Map[]{m};
                }
            }
        }
    }

    public boolean hasSolution() {
        return this.iter != null && this.iter.hasNext();
    }

    public boolean hasMoreSolutions() {
        return this.iter != null && this.iter.hasNext();
    }

    public PrologTerm[] oneSolution() {
        int index = 0;
        Map<String, PrologTerm> solution = this.oneVariablesSolution();
        PrologTerm[] array = new PrologTerm[solution.size()];
        Iterator<String> i = this.variables.iterator();
        while (i.hasNext()) {
            array[index++] = solution.get(i.next());
        }
        return array;
    }

    public Map<String, PrologTerm> oneVariablesSolution() {
        return this.solutions.length > 0 ? this.solutions[0] : new HashMap();
    }

    public PrologTerm[] nextSolution() {
        int index = 0;
        Map<String, PrologTerm> solution = this.nextVariablesSolution();
        PrologTerm[] array = new PrologTerm[solution.size()];
        Iterator<String> i = this.variables.iterator();
        while (i.hasNext()) {
            array[index++] = solution.get(i.next());
        }
        return array;
    }

    public Map<String, PrologTerm> nextVariablesSolution() {
        return this.iter.next();
    }

    public PrologTerm[][] nSolutions(int n) {
        if (n > 0) {
            int m = 0;
            ArrayList<PrologTerm[]> all = new ArrayList<PrologTerm[]>();
            for (int index = 0; this.hasNext() && index < n; ++index) {
                PrologTerm[] solution = this.nextSolution();
                m = solution.length > m ? solution.length : m;
                all.add(solution);
            }
            PrologTerm[][] allSolutions = new PrologTerm[n][m];
            for (int i = 0; i < n; ++i) {
                PrologTerm[] solution = (PrologTerm[])all.get(i);
                for (int j = 0; j < m; ++j) {
                    allSolutions[i][j] = solution[j];
                }
            }
            return allSolutions;
        }
        throw new PrologError("Impossible find " + n + " solutions");
    }

    public Map<String, PrologTerm>[] nVariablesSolutions(int n) {
        return Arrays.copyOf(this.solutions, n);
    }

    public PrologTerm[][] allSolutions() {
        int n = 0;
        int m = 0;
        ArrayList<PrologTerm[]> all = new ArrayList<PrologTerm[]>();
        while (this.hasMoreSolutions()) {
            PrologTerm[] solution = this.nextSolution();
            m = solution.length > m ? solution.length : m;
            ++n;
            all.add(solution);
        }
        PrologTerm[][] allSolutions = new PrologTerm[n][m];
        for (int i = 0; i < n; ++i) {
            PrologTerm[] solution = (PrologTerm[])all.get(i);
            for (int j = 0; j < m; ++j) {
                allSolutions[i][j] = solution[j];
            }
        }
        return allSolutions;
    }

    public Map<String, PrologTerm>[] allVariablesSolutions() {
        return this.solutions;
    }

    public void dispose() {
        this.iter = null;
        this.variables.clear();
        int l = this.solutions.length;
        for (int i = 0; i < l; ++i) {
            this.solutions[i].clear();
            this.solutions[i] = null;
        }
        this.solutions = null;
    }

    public List<Map<String, PrologTerm>> all() {
        ArrayList<Map<String, PrologTerm>> l = new ArrayList<Map<String, PrologTerm>>();
        for (Map<String, PrologTerm> map : this.solutions) {
            l.add(map);
        }
        return l;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.stringQuery.hashCode();
        result = 31 * result + this.variables.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        JplQuery other = (JplQuery)((Object)obj);
        return this.variables.equals(other.variables);
    }

    public String toString() {
        return this.stringQuery;
    }

    private class JplQueryIter
    extends AbstractIterator<Map<String, PrologTerm>>
    implements Iterator<Map<String, PrologTerm>> {
        private int nextIndex;
        private final Map<String, PrologTerm>[] maps;

        private JplQueryIter(Map<String, PrologTerm>[] maps) {
            this.maps = maps;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.maps.length;
        }

        @Override
        public Map<String, PrologTerm> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.maps[this.nextIndex++];
        }
    }
}

