/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog.jpl7;

import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologReference;
import io.github.prolobjectlink.prolog.PrologTerm;
import io.github.prolobjectlink.prolog.jpl7.JplTerm;
import org.jpl7.JPL;
import org.jpl7.Term;

public final class JplReference
extends JplTerm
implements PrologReference {
    JplReference(PrologProvider provider, Term reference) {
        super(1024, provider, reference);
    }

    JplReference(PrologProvider provider, Object reference) {
        super(1024, provider, JPL.newJRef((Object)reference));
    }

    public Class<?> getReferenceType() {
        return this.getObject().getClass();
    }

    public int getArity() {
        return this.value.arity();
    }

    public String getFunctor() {
        return "<jref>";
    }

    public PrologTerm[] getArguments() {
        return new PrologTerm[0];
    }

    public Object getObject() {
        if (this.value.isJFalse()) {
            return Boolean.FALSE;
        }
        if (this.value.isJTrue()) {
            return Boolean.TRUE;
        }
        if (this.value.isJVoid()) {
            return Void.TYPE;
        }
        if (this.value.isJRef()) {
            return this.value.object();
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type;
        result = 31 * result + (this.value == null ? 0 : this.value.toString().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JplTerm)) {
            return false;
        }
        JplTerm other = (JplTerm)((Object)obj);
        return !(this.value == null ? other.value != null : !this.getObject().equals(other.getObject()));
    }

    @Override
    public boolean unify(PrologTerm term) {
        JplReference thisTerm = this;
        PrologTerm otherTerm = term;
        if (thisTerm == otherTerm) {
            return true;
        }
        if (thisTerm.isVariable()) {
            if (thisTerm == thisTerm.getTerm()) {
                return true;
            }
            return thisTerm.getTerm().unify(otherTerm);
        }
        if (otherTerm.isVariable()) {
            if (otherTerm == otherTerm.getTerm()) {
                return true;
            }
            return otherTerm.getTerm().unify((PrologTerm)thisTerm);
        }
        return this.equals(term);
    }

    @Override
    public int compareTo(PrologTerm term) {
        JplReference thisTerm = this;
        PrologTerm otherTerm = term;
        Integer thisHashCode = ((Object)((Object)thisTerm)).hashCode();
        Integer otherHashCode = otherTerm.hashCode();
        if (thisHashCode < otherHashCode) {
            return -1;
        }
        if (thisHashCode > otherHashCode) {
            return 1;
        }
        return 0;
    }
}

