/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog.jpl7;

import io.github.prolobjectlink.prolog.AbstractTerm;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologTerm;
import org.jpl7.Atom;
import org.jpl7.Query;
import org.jpl7.Term;

abstract class JplTerm
extends AbstractTerm
implements PrologTerm {
    protected Term value;
    public static final Term JPL_TRUE = new Atom("true");

    protected JplTerm(int type, PrologProvider provider) {
        super(type, provider);
    }

    protected JplTerm(int type, PrologProvider provider, Term value) {
        super(type, provider);
        this.value = value;
    }

    public final boolean isAtom() {
        return this.value.isAtom();
    }

    public final boolean isNumber() {
        return this.isFloat() || this.isDouble() || this.isInteger() || this.isLong();
    }

    public final boolean isFloat() {
        return this.type == 514 && this.value.isFloat();
    }

    public final boolean isDouble() {
        return this.type == 515;
    }

    public final boolean isInteger() {
        return this.type == 512 && this.value.isInteger();
    }

    public final boolean isLong() {
        return this.type == 513;
    }

    public final boolean isVariable() {
        return this.value.isVariable();
    }

    public final boolean isList() {
        return this.value.isListNil() || this.value.isListPair();
    }

    public final boolean isStructure() {
        return this.isCompound() && !this.isList();
    }

    public final boolean isNil() {
        if (!this.isVariable() && !this.isNumber()) {
            return this.value.hasFunctor("nil", 0);
        }
        return false;
    }

    public final boolean isEmptyList() {
        return this.value.isListNil();
    }

    public final boolean isEvaluable() {
        if (!(this.isVariable() || this.isList() || this.isNumber() || this.getArity() != 2)) {
            String key = "LIST";
            String opQuery = "findall(OP,current_op(_,_,OP)," + key + ")";
            Query query = new Query(opQuery);
            if (query.hasSolution()) {
                Term[] termArray;
                Term term = (Term)query.oneSolution().get(key);
                for (Term termArray1 : termArray = term.toTermArray()) {
                    if (!termArray1.name().equals(this.getFunctor())) continue;
                    return true;
                }
            }
            query.close();
        }
        return false;
    }

    public final boolean isAtomic() {
        return !this.isCompound() && !this.isList();
    }

    public final boolean isCompound() {
        return this.value.isCompound();
    }

    public final boolean isTrueType() {
        return this.value.isJTrue();
    }

    public final boolean isFalseType() {
        return this.value.isJFalse();
    }

    public final boolean isNullType() {
        return this.value.isJNull();
    }

    public final boolean isVoidType() {
        return this.value.isJVoid();
    }

    public final boolean isObjectType() {
        return this.value.type() == 102;
    }

    public final boolean isReference() {
        return this.value.isJRef();
    }

    public final PrologTerm getTerm() {
        return this;
    }

    public boolean unify(PrologTerm o) {
        return this.unify((Term)this.fromTerm(o, Term.class));
    }

    private final boolean unify(Term o) {
        String q = "unify_with_occurs_check(" + this.value + "," + o + ")";
        Query query = new Query(q);
        boolean result = query.hasSolution();
        query.close();
        return result;
    }

    public int compareTo(PrologTerm o) {
        String key = "Order";
        Term term = (Term)this.fromTerm(o, Term.class);
        String arguments = key + "," + this.value + "," + term;
        Query query = new Query("compare(" + arguments + ")");
        query.open();
        Term order = (Term)query.getSolution().get(key);
        query.close();
        if (order.hasFunctor("<", 0)) {
            return -1;
        }
        if (order.hasFunctor(">", 0)) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type;
        result = 31 * result + (this.value == null ? 0 : this.value.toString().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        JplTerm other = (JplTerm)((Object)obj);
        return !(this.value == null ? other.value != null : !this.unify(other.value));
    }

    public String toString() {
        if (this.type == 772) {
            return this.getFunctor();
        }
        return "" + this.value + "";
    }
}

