/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.DefaultQueryBuilder;
import io.github.prolobjectlink.prolog.PrologBuilder;
import io.github.prolobjectlink.prolog.PrologEngine;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologTerm;

abstract class AbstractBuilder
implements PrologBuilder {
    protected StringBuilder builder;
    protected final PrologEngine engine;
    private final PrologProvider provider;

    AbstractBuilder(PrologEngine engine) {
        this.provider = engine.getProvider();
        this.builder = new StringBuilder();
        this.engine = engine;
    }

    protected final void append(Object object) {
        this.builder.append(object);
    }

    protected final void append(String functor, PrologTerm ... arguments) {
        if (arguments != null && arguments.length > 0) {
            this.builder.append(this.provider.newStructure(functor, arguments));
        } else {
            this.builder.append(this.provider.newAtom(functor));
        }
    }

    protected final void append(Object left, String operator, Object right) {
        this.builder.append(left);
        this.append(Character.valueOf(' '));
        this.builder.append(operator);
        this.append(Character.valueOf(' '));
        this.builder.append(right);
    }

    @Override
    public final PrologEngine getEngine() {
        return this.engine;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DefaultQueryBuilder other = (DefaultQueryBuilder)object;
        if (this.engine == null ? other.engine != null : !this.engine.equals(other.engine)) {
            return false;
        }
        return !(this.builder == null ? other.builder != null : !this.builder.toString().equals(other.builder.toString()));
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.engine == null ? 0 : this.engine.hashCode());
        result = 31 * result + (this.builder == null ? 0 : this.builder.hashCode());
        return result;
    }

    public final String toString() {
        return "" + this.builder + "";
    }
}

