/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.AbstractIterator;
import io.github.prolobjectlink.prolog.DefaultPrologIndicator;
import io.github.prolobjectlink.prolog.PrologClause;
import io.github.prolobjectlink.prolog.PrologIndicator;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologTerm;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractClause
implements PrologClause {
    private boolean dynamic;
    private boolean multifile;
    private boolean discontiguous;
    private final PrologTerm head;
    private final PrologTerm body;
    protected final PrologProvider provider;

    protected AbstractClause(PrologProvider provider, PrologTerm head, boolean dynamic, boolean multifile, boolean discontiguous) {
        this(provider, head, null, dynamic, multifile, discontiguous);
    }

    protected AbstractClause(PrologProvider provider, PrologTerm head, PrologTerm body, boolean dynamic, boolean multifile, boolean discontiguous) {
        this.head = head;
        this.body = body;
        this.provider = provider;
        this.dynamic = dynamic;
        this.multifile = multifile;
        this.discontiguous = discontiguous;
    }

    @Override
    public PrologTerm getTerm() {
        PrologTerm h = this.getHead();
        if (this.isRule()) {
            PrologTerm b = this.getBody();
            return this.provider.newStructure(":-", h, b);
        }
        return h;
    }

    @Override
    public final PrologTerm getHead() {
        return this.head;
    }

    @Override
    public final PrologTerm getBody() {
        return this.body;
    }

    @Override
    public final PrologTerm[] getBodyArray() {
        PrologTerm ptr;
        ArrayList<PrologTerm> terms = new ArrayList<PrologTerm>();
        for (ptr = this.getBody(); ptr != null && ptr.isCompound() && ptr.hasIndicator(",", 2); ptr = ptr.getArgument(1)) {
            terms.add(ptr.getArgument(0));
        }
        terms.add(ptr);
        return terms.toArray(new PrologTerm[0]);
    }

    @Override
    public final Iterator<PrologTerm> getBodyIterator() {
        return new BodyIterator(this.getBodyArray());
    }

    @Override
    public final String getFunctor() {
        return this.head.getFunctor();
    }

    @Override
    public final int getArity() {
        return this.head.getArity();
    }

    @Override
    public PrologTerm[] getArguments() {
        return this.head.getArguments();
    }

    @Override
    public PrologTerm getArgument(int index) {
        return this.head.getArgument(index);
    }

    @Override
    public final boolean hasIndicator(String functor, int arity) {
        return this.getHead().hasIndicator(functor, arity);
    }

    @Override
    public final String getIndicator() {
        return this.head.getIndicator();
    }

    @Override
    public final boolean isDirective() {
        return this.head == null && this.body != null;
    }

    @Override
    public final boolean isFact() {
        return this.head != null && this.body == null;
    }

    @Override
    public final boolean isRule() {
        return this.head != null && this.body != null;
    }

    @Override
    public boolean isMethod() {
        return false;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public final boolean isClause() {
        return true;
    }

    @Override
    public final boolean isTerm() {
        return false;
    }

    @Override
    public final boolean unify(PrologClause clause) {
        return this.head.unify(clause.getHead()) && this.body.unify(clause.getBody());
    }

    @Override
    public final boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public final boolean isMultifile() {
        return this.multifile;
    }

    @Override
    public final boolean isDiscontiguous() {
        return this.discontiguous;
    }

    @Override
    public PrologIndicator getPrologIndicator() {
        return new DefaultPrologIndicator(this.getFunctor(), this.getArity());
    }

    @Override
    public final <T extends PrologClause> T cast() {
        return (T)this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        result = 31 * result + (this.discontiguous ? 1231 : 1237);
        result = 31 * result + (this.dynamic ? 1231 : 1237);
        result = 31 * result + (this.head == null ? 0 : this.head.hashCode());
        result = 31 * result + (this.multifile ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractClause other = (AbstractClause)obj;
        if (this.body == null ? other.body != null : !this.body.equals(other.body)) {
            return false;
        }
        if (this.discontiguous != other.discontiguous) {
            return false;
        }
        if (this.dynamic != other.dynamic) {
            return false;
        }
        if (this.head == null ? other.head != null : !this.head.equals(other.head)) {
            return false;
        }
        return this.multifile == other.multifile;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getHead());
        if (this.isRule()) {
            b.append(":-\n\t");
            Iterator<PrologTerm> i = this.getBodyIterator();
            while (i.hasNext()) {
                b.append(i.next());
                if (!i.hasNext()) continue;
                b.append(",\n\t");
            }
        }
        b.append('.');
        return "" + b + "";
    }

    private class BodyIterator
    extends AbstractIterator<PrologTerm>
    implements Iterator<PrologTerm> {
        private int nextIndex;
        private final PrologTerm[] elements;

        protected BodyIterator(PrologTerm[] elements) {
            this.elements = elements;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.elements.length;
        }

        @Override
        public PrologTerm next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.elements[this.nextIndex++];
        }
    }
}

