/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.AbstractTerm;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologTerm;

public abstract class AbstractCompounds
extends AbstractTerm
implements PrologTerm {
    public AbstractCompounds(int type, PrologProvider provider) {
        super(type, provider);
    }

    @Override
    public final boolean isAtom() {
        return false;
    }

    @Override
    public final boolean isNumber() {
        return false;
    }

    @Override
    public final boolean isFloat() {
        return false;
    }

    @Override
    public final boolean isInteger() {
        return false;
    }

    @Override
    public final boolean isDouble() {
        return false;
    }

    @Override
    public final boolean isLong() {
        return false;
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public final boolean isNil() {
        return false;
    }

    @Override
    public final boolean isAtomic() {
        return false;
    }

    @Override
    public final boolean isCompound() {
        return true;
    }

    @Override
    public final boolean isEvaluable() {
        return false;
    }

    @Override
    public final boolean isTrueType() {
        Object object = this.getObject();
        return object != null && object.equals(true);
    }

    @Override
    public final boolean isFalseType() {
        Object object = this.getObject();
        return object != null && object.equals(false);
    }

    @Override
    public final boolean isNullType() {
        return this.isObjectType() && this.getObject() == null;
    }

    @Override
    public final boolean isVoidType() {
        return this.getObject() == Void.TYPE;
    }

    @Override
    public final boolean isObjectType() {
        return this.getType() == 1024;
    }

    @Override
    public final boolean isReference() {
        return this.isObjectType();
    }

    @Override
    public final int compareTo(PrologTerm term) {
        AbstractCompounds thisCompound = this;
        PrologTerm otherCompound = term;
        if (!otherCompound.isCompound()) {
            if (otherCompound.isEmptyList() && thisCompound.isEmptyList()) {
                return 0;
            }
            return 1;
        }
        if (otherCompound.isEmptyList() && thisCompound.isEmptyList()) {
            return 0;
        }
        if (thisCompound.getArity() < otherCompound.getArity()) {
            return -1;
        }
        if (thisCompound.getArity() > otherCompound.getArity()) {
            return 1;
        }
        int result = thisCompound.getFunctor().compareTo(otherCompound.getFunctor());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        PrologTerm[] thisArguments = thisCompound.getArguments();
        PrologTerm[] otherArguments = otherCompound.getArguments();
        for (int i = 0; i < thisArguments.length; ++i) {
            PrologTerm thisArgument = thisArguments[i];
            PrologTerm otherArgument = otherArguments[i];
            if (thisArgument == null || otherArgument == null || (result = thisArgument.compareTo(otherArgument)) == 0) continue;
            return result;
        }
        return 0;
    }

    @Override
    public final boolean unify(PrologTerm term) {
        AbstractCompounds thisTerm = this;
        PrologTerm otherTerm = term;
        if (thisTerm == otherTerm) {
            return true;
        }
        if (thisTerm.isVariable()) {
            if (thisTerm == thisTerm.getTerm()) {
                return true;
            }
            return thisTerm.getTerm().unify(otherTerm);
        }
        if (otherTerm.isVariable()) {
            if (otherTerm == otherTerm.getTerm()) {
                return true;
            }
            return otherTerm.getTerm().unify(thisTerm);
        }
        if (otherTerm.isCompound()) {
            String otherFunctor;
            int thisArity = thisTerm.getArity();
            int otherArity = otherTerm.getArity();
            String thisFunctor = thisTerm.getFunctor();
            if (thisFunctor.equals(otherFunctor = otherTerm.getFunctor()) && thisArity == otherArity) {
                PrologTerm[] otherArguments;
                PrologTerm[] thisArguments = thisTerm.getArguments();
                if (thisArguments.length == (otherArguments = otherTerm.getArguments()).length) {
                    for (int i = 0; i < thisArguments.length; ++i) {
                        PrologTerm otherArgument;
                        PrologTerm thisArgument;
                        if (thisArguments[i] == null || otherArguments[i] == null || (thisArgument = thisArguments[i]).unify(otherArgument = otherArguments[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

