/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.ArrayIterator;
import io.github.prolobjectlink.prolog.PrologConsole;
import io.github.prolobjectlink.prolog.PrologEngine;
import io.github.prolobjectlink.prolog.PrologIndicator;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologQuery;
import io.github.prolobjectlink.prolog.PrologTerm;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractConsole
implements PrologConsole {
    private static final String PROLOBJECTLINK = "Prolobjectlink";
    private static final String COPYRIHT = " (C)";
    private static final InputStream STDIN = System.in;
    private final InputStreamReader input = new InputStreamReader(STDIN);
    private final BufferedReader reader = new BufferedReader(this.input);
    private final PrintWriter output = new PrintWriter(System.out, true);
    private final PrologEngine engine;

    public AbstractConsole(PrologProvider provider) {
        this.engine = provider.newEngine();
    }

    @Override
    public final Map<String, String> getArguments(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (args.length > 0) {
            ArrayIterator<String> i = new ArrayIterator<String>(args);
            String name = (String)i.next();
            if (i.hasNext()) {
                String value = (String)i.next();
                map.put(name, value);
            } else {
                map.put(name, "");
            }
        }
        return map;
    }

    @Override
    public final void printUsage() {
        this.output.println("Usage: pllink option [file]");
        this.output.println("options:");
        this.output.println("\t-r\tconsult/run a prolog file");
        this.output.println("\t-v\tprint the prolog engine version");
        this.output.println("\t-n\tprint the prolog engine name");
        this.output.println("\t-l\tprint the prolog engine license");
        this.output.println("\t-i\tprint the prolog engine information");
        this.output.println("\t-a\tprint the prolog engine about");
        this.output.println("\t-e\tprint the prolog engine enviroment paths");
        this.output.println("\t-x\tstart the prolog engine execution");
        this.output.println("\t-w\tprint the current work directory ");
        this.output.println("\t-f\tconsult a prolog file and save formatted code");
        this.output.println("\t-t\ttest and report integration conditions");
        this.output.println("\t-p\tprint in a file a snapshot of currents predicates");
        this.output.println("\t-s\tgenerate .project file for Prolog Development Tool");
    }

    @Override
    public final void run(String[] args) {
        Map<String, String> m = this.getArguments(args);
        if (!m.isEmpty()) {
            String file;
            if (m.containsKey("-v")) {
                this.output.println(this.engine.getVersion());
            } else if (m.containsKey("-n")) {
                this.output.println(this.engine.getName());
            } else if (m.containsKey("-l")) {
                this.output.println(this.engine.getLicense());
            } else if (m.containsKey("-i")) {
                this.output.print(PROLOBJECTLINK);
                this.output.print(COPYRIHT);
                this.output.print(" ");
                this.output.print(this.engine.getName());
                this.output.print(" v");
                this.output.println(this.engine.getVersion());
                this.output.println(this.engine.getLicense());
                this.output.println(System.getProperty("java.vm.name"));
                this.output.println(System.getProperty("java.vendor"));
                this.output.println(System.getProperty("java.version"));
                this.output.println();
            } else if (m.containsKey("-w")) {
                try {
                    this.output.println("Working directory");
                    ProtectionDomain p = this.getClass().getProtectionDomain();
                    URI d = p.getCodeSource().getLocation().toURI();
                    this.output.println(d);
                }
                catch (URISyntaxException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            } else if (m.containsKey("-e")) {
                this.output.println("Enviroment");
                this.output.println("Class path");
                this.output.println(System.getenv("java.class.path"));
                this.output.println("System path");
                this.output.println(System.getenv("Path"));
            } else if (m.containsKey("-a")) {
                this.output.print(PROLOBJECTLINK);
                this.output.print(COPYRIHT);
            } else if (m.containsKey("-r")) {
                file = m.get("-r");
                this.output.print("Consult ");
                this.output.println(file);
                this.engine.consult(file);
            } else if (!m.containsKey("-x")) {
                if (m.containsKey("-f")) {
                    file = m.get("-r");
                    this.output.print("Format ");
                    this.output.println(file);
                    this.engine.consult(file);
                    this.engine.persist(file);
                } else if (m.containsKey("-t")) {
                    List<String> status = this.engine.verify();
                    for (String string : status) {
                        this.output.println(string);
                    }
                } else if (m.containsKey("-p")) {
                    file = m.get("-p");
                    try {
                        PrintWriter writter = new PrintWriter(file);
                        Set<PrologIndicator> set = this.engine.currentPredicates();
                        for (PrologIndicator prologIndicator : set) {
                            writter.println(prologIndicator);
                        }
                        writter.close();
                    }
                    catch (FileNotFoundException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                        System.exit(1);
                    }
                } else if (m.containsKey("-h")) {
                    System.exit(1);
                    this.printUsage();
                } else {
                    this.printUsage();
                    System.exit(1);
                }
            }
            try {
                this.output.print("?- ");
                this.output.flush();
                String queryString = this.reader.readLine();
                while (true) {
                    if (!queryString.equals("")) {
                        PrologQuery query;
                        this.output.println();
                        if (queryString.lastIndexOf(46) == queryString.length() - 1) {
                            queryString = queryString.substring(0, queryString.length() - 1);
                        }
                        if ((query = this.engine.query(queryString)).hasSolution()) {
                            Map<String, PrologTerm> s = query.oneVariablesSolution();
                            for (Map.Entry<String, PrologTerm> e : s.entrySet()) {
                                this.output.println(e.getKey() + " = " + e.getValue());
                            }
                            this.output.println();
                            this.output.println("Yes.");
                        } else {
                            this.output.println("No.");
                        }
                        this.output.println();
                        this.output.println();
                    } else {
                        this.output.println("Emty query");
                        this.output.println();
                    }
                    this.output.print("?- ");
                    this.output.flush();
                    queryString = this.reader.readLine();
                }
            }
            catch (UnsatisfiedLinkError e) {
                this.output.println("Prolog engine link conditions:");
                List<String> status = this.engine.verify();
                for (String string : status) {
                    this.output.println(string);
                }
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                System.exit(1);
            }
        } else {
            this.printUsage();
            System.exit(1);
        }
    }
}

