/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.PrologConverter;
import io.github.prolobjectlink.prolog.PrologError;
import io.github.prolobjectlink.prolog.PrologLogger;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologTerm;
import io.github.prolobjectlink.prolog.PrologVariable;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractConverter<T>
implements PrologConverter<T> {
    public static final String SIMPLE_ATOM_REGEX = ".|[a-z][A-Za-z0-9_]*";
    private static final String IMPOSIBLE_CONVERT = "Impossible convert '";
    private static final String FROM = "' from '";
    private static final String TO = "' to '";
    protected final HashMap<String, PrologVariable> sharedVariables = new HashMap();
    protected final HashMap<String, T> sharedPrologVariables = new HashMap();
    protected final PrologProvider provider = this.createProvider();

    protected AbstractConverter() {
    }

    protected final PrologLogger getLogger() {
        return this.provider.getLogger();
    }

    private final boolean isQuoted(String functor) {
        if (!functor.isEmpty()) {
            char beginChar = functor.charAt(0);
            char endChar = functor.charAt(functor.length() - 1);
            return beginChar == '\'' && endChar == '\'';
        }
        return false;
    }

    public final String removeQuoted(String functor) {
        if (this.isQuoted(functor)) {
            String newFunctor = "";
            newFunctor = newFunctor + functor.substring(1, functor.length() - 1);
            return newFunctor;
        }
        return functor;
    }

    @Override
    public final PrologTerm[] toTermArray(T[] terms) {
        PrologTerm[] iTerms = new PrologTerm[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            iTerms[i] = this.toTerm(terms[i]);
        }
        return iTerms;
    }

    @Override
    public final PrologTerm[][] toTermMatrix(T[][] terms) {
        int n = terms.length;
        int m = terms[0].length;
        PrologTerm[][] iTerms = new PrologTerm[n][m];
        for (int i = 0; i < n; ++i) {
            iTerms[i] = this.toTermArray(terms[i]);
        }
        return iTerms;
    }

    @Override
    public final Map<String, PrologTerm> toTermMap(Map<String, T> map) {
        HashMap<String, PrologTerm> solutionMap = new HashMap<String, PrologTerm>(map.size());
        Set<String> keys = map.keySet();
        for (String key : keys) {
            solutionMap.put(key, this.toTerm(map.get(key)));
        }
        return solutionMap;
    }

    @Override
    public final Map<String, PrologTerm>[] toTermMapArray(Map<String, T>[] map) {
        Map[] solutions = new Map[map.length];
        for (int i = 0; i < map.length; ++i) {
            solutions[i] = this.toTermMap(map[i]);
        }
        return solutions;
    }

    @Override
    public final <K extends PrologTerm> K toTerm(Object o, Class<K> from) {
        PrologTerm term;
        Class<T> clazz = this.getGenericClass();
        if (clazz != null && clazz.isAssignableFrom(o.getClass()) && from.isAssignableFrom((term = this.toTerm(o)).getClass())) {
            return (K)((PrologTerm)from.cast(term));
        }
        throw new PrologError(IMPOSIBLE_CONVERT + o + FROM + from + "'");
    }

    @Override
    public final <K extends PrologTerm> K[] toTermArray(Object[] os, Class<K[]> from) {
        PrologTerm[] terms;
        Class<T> clazz = this.getGenericClass();
        Class<?> cType = os.getClass().getComponentType();
        if (clazz != null && clazz.isAssignableFrom(cType) && from.isAssignableFrom((terms = this.toTermArray(os)).getClass())) {
            return (PrologTerm[])from.cast(terms);
        }
        throw new PrologError(IMPOSIBLE_CONVERT + Arrays.toString(os) + FROM + from + "'");
    }

    @Override
    public final <K extends PrologTerm> K[][] toTermMatrix(Object[][] oss, Class<K[][]> from) {
        PrologTerm[][] terms;
        Class<T> clazz = this.getGenericClass();
        Class<?> cType = oss.getClass().getComponentType();
        Class<?> c = Array.newInstance(clazz, 0).getClass();
        if (c.isAssignableFrom(cType) && from.isAssignableFrom((terms = this.toTermMatrix(oss)).getClass())) {
            return (PrologTerm[][])from.cast(terms);
        }
        throw new PrologError(IMPOSIBLE_CONVERT + Arrays.toString((Object[])oss) + FROM + from + "'");
    }

    @Override
    public final <K extends PrologTerm, V> Map<String, PrologTerm> toTermMap(Map<String, V> map, Class<K> from) {
        HashMap<String, PrologTerm> solutionMap = new HashMap<String, PrologTerm>(map.size());
        Set<String> keys = map.keySet();
        for (String key : keys) {
            V o = map.get(key);
            K term = this.toTerm(o, from);
            solutionMap.put(key, (PrologTerm)term);
        }
        return solutionMap;
    }

    @Override
    public final <K extends PrologTerm, V> Map<String, PrologTerm>[] toTermMapArray(Map<String, V>[] map, Class<K> from) {
        Map[] solutions = new Map[map.length];
        for (int i = 0; i < map.length; ++i) {
            solutions[i] = this.toTermMap(map[i], from);
        }
        return solutions;
    }

    @Override
    public final <K> K fromTerm(PrologTerm term, Class<K> to) {
        Object t = this.fromTerm(term);
        if (to.isAssignableFrom(t.getClass())) {
            return to.cast(t);
        }
        throw new PrologError(IMPOSIBLE_CONVERT + term + TO + to + "'");
    }

    @Override
    public final <K> K[] fromTermArray(PrologTerm[] terms, Class<K[]> to) {
        T[] ts = this.fromTermArray(terms);
        if (to.isAssignableFrom(ts.getClass())) {
            return to.cast(ts);
        }
        throw new PrologError(IMPOSIBLE_CONVERT + Arrays.toString(terms) + TO + to + "'");
    }

    @Override
    public final <K> K fromTerm(PrologTerm head, PrologTerm[] body, Class<K> to) {
        Object t = this.fromTerm(head, body);
        if (to.isAssignableFrom(t.getClass())) {
            return to.cast(t);
        }
        throw new PrologError(IMPOSIBLE_CONVERT + head + " and " + Arrays.toString(body) + TO + to + "'");
    }

    @Override
    public final Class<T> getGenericClass() {
        ParameterizedType parameterized;
        Type type;
        Class templateClass = null;
        Type[] generics = this.getClass().getGenericInterfaces();
        if (generics.length == 1 && generics[0] instanceof ParameterizedType && (type = (parameterized = (ParameterizedType)generics[0]).getActualTypeArguments()[0]) instanceof Class) {
            templateClass = (Class)type;
        }
        return templateClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sharedPrologVariables == null ? 0 : this.sharedPrologVariables.hashCode());
        result = 31 * result + (this.sharedVariables == null ? 0 : this.sharedVariables.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractConverter other = (AbstractConverter)obj;
        if (this.sharedPrologVariables == null ? other.sharedPrologVariables != null : !this.sharedPrologVariables.equals(other.sharedPrologVariables)) {
            return false;
        }
        return !(this.sharedVariables == null ? other.sharedVariables != null : !this.sharedVariables.equals(other.sharedVariables));
    }
}

