/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.AbstractIterator;
import io.github.prolobjectlink.prolog.DefaultClauseBuilder;
import io.github.prolobjectlink.prolog.DefaultQueryBuilder;
import io.github.prolobjectlink.prolog.PrologClause;
import io.github.prolobjectlink.prolog.PrologEngine;
import io.github.prolobjectlink.prolog.PrologIndicator;
import io.github.prolobjectlink.prolog.PrologLogger;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologTerm;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class AbstractEngine
implements PrologEngine {
    protected final PrologProvider provider;
    private static final String UNKNOWN = "unknown";

    protected AbstractEngine(PrologProvider provider) {
        this.provider = provider;
    }

    @Override
    public final PrologProvider getProvider() {
        return this.provider;
    }

    @Override
    public final void persist(Writer writer) {
        AbstractEngine thisEngine = this;
        for (PrologClause prologClause : thisEngine) {
            try {
                writer.write("" + prologClause + "");
            }
            catch (IOException e) {
                this.getLogger().error(this.getClass(), "Some error occurs opening the file", e);
            }
        }
    }

    @Override
    public final boolean unify(PrologTerm t1, PrologTerm t2) {
        return t1.unify(t2);
    }

    @Override
    public final boolean contains(String goal) {
        return this.query(goal).hasSolution();
    }

    @Override
    public final boolean contains(PrologTerm goal) {
        return this.query(goal).hasSolution();
    }

    @Override
    public final boolean contains(PrologTerm goal, PrologTerm ... goals) {
        return this.query(goal, goals).hasSolution();
    }

    @Override
    public final Map<String, PrologTerm> queryOne(String goal) {
        return this.query(goal).oneVariablesSolution();
    }

    @Override
    public final Map<String, PrologTerm> queryOne(PrologTerm goal) {
        return this.query(goal).oneVariablesSolution();
    }

    @Override
    public final Map<String, PrologTerm> queryOne(PrologTerm goal, PrologTerm ... goals) {
        return this.query(goal, goals).oneVariablesSolution();
    }

    @Override
    public final List<Map<String, PrologTerm>> queryN(int n, String goal) {
        return Arrays.asList(this.query(goal).nVariablesSolutions(n));
    }

    @Override
    public final List<Map<String, PrologTerm>> queryN(int n, PrologTerm term) {
        return Arrays.asList(this.query(term).nVariablesSolutions(n));
    }

    @Override
    public final List<Map<String, PrologTerm>> queryN(int n, PrologTerm term, PrologTerm ... terms) {
        return Arrays.asList(this.query(term, terms).nVariablesSolutions(n));
    }

    @Override
    public final List<Map<String, PrologTerm>> queryAll(String goal) {
        return this.query(goal).all();
    }

    @Override
    public final List<Map<String, PrologTerm>> queryAll(PrologTerm goal) {
        return this.query(goal).all();
    }

    @Override
    public final List<Map<String, PrologTerm>> queryAll(PrologTerm goal, PrologTerm ... goals) {
        return this.query(goal, goals).all();
    }

    @Override
    public final Map<String, List<PrologClause>> getProgramMap() {
        HashMap<String, List<PrologClause>> m = new HashMap<String, List<PrologClause>>();
        for (PrologClause clause : this) {
            String key = clause.getIndicator();
            ArrayList<PrologClause> l = (ArrayList<PrologClause>)m.get(key);
            if (l == null) {
                l = new ArrayList<PrologClause>();
                l.add(clause);
                m.put(key, l);
                continue;
            }
            l.add(clause);
        }
        return m;
    }

    @Override
    public final Set<PrologClause> getProgramClauses() {
        LinkedHashSet<PrologClause> c = new LinkedHashSet<PrologClause>();
        for (PrologClause prologClause : this) {
            c.add(prologClause);
        }
        return c;
    }

    @Override
    public final boolean isProgramEmpty() {
        return this.getProgramSize() == 0;
    }

    @Override
    public final Set<PrologIndicator> currentPredicates() {
        HashSet<PrologIndicator> pis = new HashSet<PrologIndicator>();
        pis.addAll(this.getPredicates());
        pis.addAll(this.getBuiltIns());
        return pis;
    }

    @Override
    public final DefaultQueryBuilder newQueryBuilder() {
        return new DefaultQueryBuilder(this);
    }

    @Override
    public final DefaultClauseBuilder newClauseBuilder() {
        return new DefaultClauseBuilder(this);
    }

    @Override
    public final boolean runOnOSX() {
        return this.getOSName().equals("Mac OS X") || this.getOSName().equals("Darwin");
    }

    @Override
    public final boolean runOnWindows() {
        return this.getOSName().startsWith("Windows");
    }

    @Override
    public final boolean runOnLinux() {
        return this.getOSName().equals("Linux");
    }

    @Override
    public final String getOSName() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return UNKNOWN;
        }
        return os;
    }

    @Override
    public final String getOSVersion() {
        return System.getProperty("os.version");
    }

    @Override
    public final String getOSArch() {
        return System.getProperty("os.arch");
    }

    @Override
    public final PrologLogger getLogger() {
        return this.provider.getLogger();
    }

    protected final <K extends PrologTerm> K toTerm(Object o, Class<K> from) {
        return this.provider.toTerm(o, from);
    }

    protected final <K extends PrologTerm, V> Map<String, PrologTerm>[] toTermMapArray(Map<String, V>[] map, Class<K> from) {
        return this.provider.toTermMapArray(map, from);
    }

    protected final <K> K fromTerm(PrologTerm term, Class<K> to) {
        return this.provider.fromTerm(term, to);
    }

    protected final <K> K fromTerm(PrologTerm head, PrologTerm[] body, Class<K> to) {
        return this.provider.fromTerm(head, body, to);
    }

    protected final String removeQuoted(String functor) {
        if (functor != null && functor.startsWith("'") && functor.endsWith("'")) {
            return functor.substring(1, functor.length() - 1);
        }
        return functor;
    }

    public final String toString() {
        return this.getName() + " " + this.getVersion();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.provider == null ? 0 : this.provider.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractEngine other = (AbstractEngine)object;
        return !(this.provider == null ? other.provider != null : !this.provider.equals(other.provider));
    }

    protected class PrologProgramIterator
    extends AbstractIterator<PrologClause>
    implements Iterator<PrologClause> {
        private PrologClause last;
        private final Iterator<PrologClause> i;

        public PrologProgramIterator(Collection<PrologClause> cls) {
            this.i = cls.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public PrologClause next() {
            if (!this.i.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.i.next();
            return this.last;
        }

        @Override
        public void remove() {
            PrologTerm h = this.last.getHead();
            PrologTerm b = this.last.getBody();
            AbstractEngine.this.retract(h, b);
            this.i.remove();
        }
    }
}

