/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.PrologDouble;
import io.github.prolobjectlink.prolog.PrologFloat;
import io.github.prolobjectlink.prolog.PrologInteger;
import io.github.prolobjectlink.prolog.PrologJavaConverter;
import io.github.prolobjectlink.prolog.PrologLong;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologTerm;
import io.github.prolobjectlink.prolog.UnknownTermError;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractJavaConverter
implements PrologJavaConverter {
    private final PrologProvider provider;

    protected AbstractJavaConverter(PrologProvider provider) {
        this.provider = provider;
    }

    @Override
    public final boolean containQuotes(String functor) {
        if (functor != null && !functor.isEmpty()) {
            return functor.startsWith("'") && functor.endsWith("'");
        }
        return false;
    }

    @Override
    public final String removeQuotes(String functor) {
        if (this.containQuotes(functor)) {
            return functor.substring(1, functor.length() - 1);
        }
        return functor;
    }

    @Override
    public final Object toObject(PrologTerm prologTerm) {
        if (prologTerm == null) {
            return null;
        }
        switch (prologTerm.getType()) {
            case 769: {
                return null;
            }
            case 771: {
                return true;
            }
            case 770: {
                return false;
            }
            case 768: {
                return this.removeQuotes(prologTerm.getFunctor());
            }
            case 512: {
                return ((PrologInteger)prologTerm).getIntegerValue();
            }
            case 514: {
                return Float.valueOf(((PrologFloat)prologTerm).getFloatValue());
            }
            case 513: {
                return ((PrologLong)prologTerm).getLongValue();
            }
            case 515: {
                return ((PrologDouble)prologTerm).getDoubleValue();
            }
            case 256: {
                return prologTerm;
            }
            case 1281: {
                return this.toObjectsArray(prologTerm.getArguments());
            }
            case 1282: {
                return prologTerm;
            }
            case 1024: {
                return prologTerm.getObject();
            }
        }
        throw new UnknownTermError(prologTerm);
    }

    @Override
    public final Object[] toObjectsArray(PrologTerm[] terms) {
        Object array = Array.newInstance(Object.class, terms.length);
        for (int i = 0; i < terms.length; ++i) {
            Array.set(array, i, this.toObject(terms[i]));
        }
        return (Object[])array;
    }

    @Override
    public final PrologTerm toTerm(Object object) {
        if (object == null) {
            return this.provider.prologNil();
        }
        if (object instanceof String) {
            return this.provider.newAtom("" + (String)object + "");
        }
        if (object.getClass() == Character.TYPE || object instanceof Character) {
            return this.provider.newAtom("" + (String)object + "");
        }
        if (object.getClass() == Byte.TYPE || object instanceof Byte) {
            return this.provider.newInteger((Integer)object);
        }
        if (object.getClass() == Short.TYPE || object instanceof Short) {
            return this.provider.newInteger((Integer)object);
        }
        if (object.getClass() == Boolean.TYPE || object instanceof Boolean) {
            return (Boolean)object != false ? this.provider.prologTrue() : this.provider.prologFalse();
        }
        if (object.getClass() == Integer.TYPE || object instanceof Integer) {
            return this.provider.newInteger((Integer)object);
        }
        if (object.getClass() == Float.TYPE || object instanceof Float) {
            return this.provider.newFloat((Float)object);
        }
        if (object.getClass() == Long.TYPE || object instanceof Long) {
            return this.provider.newLong((Long)object);
        }
        if (object.getClass() == Double.TYPE || object instanceof Double) {
            return this.provider.newDouble((Double)object);
        }
        if (object instanceof Object[]) {
            return this.provider.newList(this.toTermsArray((Object[])object));
        }
        throw new UnknownTermError(object);
    }

    @Override
    public final PrologTerm[] toTermsArray(Object[] objects) {
        PrologTerm[] terms = new PrologTerm[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            terms[i] = this.toTerm(objects[i]);
        }
        return terms;
    }

    @Override
    public final List<Map<String, Object>> toObjectMaps(Map<String, PrologTerm>[] maps) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(maps.length);
        for (Map<String, PrologTerm> map : maps) {
            list.add(this.toObjectMap(map));
        }
        return list;
    }

    @Override
    public final Map<String, Object> toObjectMap(Map<String, PrologTerm> map) {
        HashMap<String, Object> objects = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, PrologTerm> entry : map.entrySet()) {
            objects.put(entry.getKey(), this.toObject(entry.getValue()));
        }
        return objects;
    }

    @Override
    public final List<Object> toObjectList(PrologTerm[] terms) {
        ArrayList<Object> list = new ArrayList<Object>(terms.length);
        for (PrologTerm prologTerm : terms) {
            list.add(this.toObject(prologTerm));
        }
        return list;
    }

    @Override
    public final List<List<Object>> toObjectLists(PrologTerm[][] terms) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>(terms.length);
        for (PrologTerm[] prologTerms : terms) {
            list.add(this.toObjectList(prologTerms));
        }
        return list;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.provider == null ? 0 : this.provider.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractJavaConverter other = (AbstractJavaConverter)obj;
        return !(this.provider == null ? other.provider != null : !this.provider.equals(other.provider));
    }
}

