/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.PrologOperator;

public abstract class AbstractOperator
implements PrologOperator {
    private final int priority;
    private final String specifier;
    private final String operator;

    public AbstractOperator(int priority, String specifier, String operator) {
        this.priority = priority;
        this.specifier = specifier;
        this.operator = operator;
    }

    @Override
    public final int getPriority() {
        return this.priority;
    }

    @Override
    public final String getSpecifier() {
        return this.specifier;
    }

    @Override
    public final String getOperator() {
        return this.operator;
    }

    public final String toString() {
        return "op(" + this.priority + "," + this.specifier + "," + this.operator + ")";
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + (this.specifier == null ? 0 : this.specifier.hashCode());
        return result;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractOperator other = (AbstractOperator)object;
        if (this.operator == null ? other.operator != null : !this.operator.equals(other.operator)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        return !(this.specifier == null ? other.specifier != null : !this.specifier.equals(other.specifier));
    }

    @Override
    public int compareTo(PrologOperator o) {
        if (this.operator != null) {
            if (this.priority > o.getPriority()) {
                return 1;
            }
            if (this.priority < o.getPriority()) {
                return -1;
            }
        }
        return 0;
    }
}

