/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.PrologClause;
import io.github.prolobjectlink.prolog.PrologClauses;
import io.github.prolobjectlink.prolog.PrologEngine;
import io.github.prolobjectlink.prolog.PrologIndicator;
import io.github.prolobjectlink.prolog.PrologProgram;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractProgram
extends AbstractMap<String, PrologClauses>
implements PrologProgram {
    protected final PrologEngine engine;

    protected AbstractProgram(PrologEngine engine) {
        this.engine = engine;
    }

    @Override
    public Iterator<PrologClauses> iterator() {
        return this.getClauses().values().iterator();
    }

    @Override
    public PrologClauses get(String functor, int arity) {
        String key = functor + "/" + arity;
        List<PrologClause> l = this.engine.getProgramMap().get(key);
        PrologClauses clauses = this.newClauses(functor, arity);
        for (PrologClause prologClause : l) {
            clauses.add(prologClause);
        }
        return clauses;
    }

    @Override
    public void add(PrologClause clause) {
        this.engine.assertz(clause.getHead(), clause.getBody());
    }

    @Override
    public void add(PrologProgram program) {
        for (PrologClauses prologClauses : program) {
            for (PrologClause clause : prologClauses) {
                this.engine.assertz(clause.getHead(), clause.getBody());
            }
        }
    }

    @Override
    public void push(PrologClause clause) {
        this.engine.asserta(clause.getHead(), clause.getBody());
    }

    public void removeAll(String key) {
        String functor = key.substring(0, key.lastIndexOf(47));
        String number = key.substring(key.lastIndexOf(47) + 1, key.length());
        int arity = Integer.parseInt(number);
        this.engine.abolish(functor, arity);
    }

    @Override
    public void removeAll(String functor, int arity) {
        this.engine.abolish(functor, arity);
    }

    @Override
    public void markDynamic(String functor, int arity) {
    }

    @Override
    public void unmarkDynamic(String functor, int arity) {
    }

    @Override
    public boolean isDynamic(String functor, int arity) {
        return this.getClauses().get(functor + "/" + arity).isDynamic();
    }

    @Override
    public void markMultifile(String functor, int arity) {
    }

    @Override
    public void unmarkMultifile(String functor, int arity) {
    }

    @Override
    public boolean isMultifile(String functor, int arity) {
        return this.getClauses().get(functor + "/" + arity).isMultifile();
    }

    @Override
    public void markDiscontiguous(String functor, int arity) {
    }

    @Override
    public void unmarkDiscontiguous(String functor, int arity) {
    }

    @Override
    public boolean isDiscontiguous(String functor, int arity) {
        return this.getClauses().get(functor + "/" + arity).isDiscontiguous();
    }

    @Override
    public boolean removeAll(PrologProgram program) {
        for (Map.Entry entry : program.entrySet()) {
            this.getClauses().remove(entry.getKey());
        }
        return true;
    }

    @Override
    public boolean removeAll(PrologClauses clauses) {
        this.getClauses().remove(clauses.getIndicator());
        return true;
    }

    @Override
    public Map<String, PrologClauses> getClauses() {
        Map<String, List<PrologClause>> p = this.engine.getProgramMap();
        HashMap<String, PrologClauses> m = new HashMap<String, PrologClauses>(p.size());
        for (List<PrologClause> clauses : p.values()) {
            for (PrologClause clause : clauses) {
                PrologClauses c = (PrologClauses)m.get(clause.getIndicator());
                if (c == null) {
                    c = this.newClauses(clause.getFunctor(), clause.getArity());
                }
                c.add(clause);
            }
        }
        return m;
    }

    @Override
    public Set<String> getIndicators() {
        Set<PrologIndicator> is = this.engine.currentPredicates();
        HashSet<String> i = new HashSet<String>(is.size());
        for (PrologIndicator prologIndicator : is) {
            i.add(prologIndicator.toString());
        }
        return i;
    }

    @Override
    public void add(PrologClauses clauses) {
        for (PrologClause prologClause : clauses) {
            this.engine.assertz(prologClause.getHead(), prologClause.getBody());
        }
    }

    @Override
    public void addAll(PrologProgram program) {
        for (PrologClauses clauses : program) {
            for (PrologClause prologClause : clauses) {
                this.engine.assertz(prologClause.getHead(), prologClause.getBody());
            }
        }
    }

    @Override
    public boolean retainAll(PrologClauses parents) {
        Map<String, PrologClauses> m = this.getClauses();
        for (PrologClauses prologClauses : m.values()) {
            if (parents.contains(prologClauses)) continue;
            String functor = ((PrologClause)prologClauses.get(0)).getFunctor();
            int arity = ((PrologClause)prologClauses.get(0)).getArity();
            this.engine.abolish(functor, arity);
        }
        return true;
    }

    @Override
    public Object[] toArray(PrologClauses[] prologClauses) {
        return this.getClauses().values().toArray(prologClauses);
    }

    @Override
    public Object[] toArray() {
        return this.getClauses().values().toArray();
    }

    @Override
    public Set<Map.Entry<String, PrologClauses>> entrySet() {
        return this.getClauses().entrySet();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.engine == null ? 0 : this.engine.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProgram other = (AbstractProgram)obj;
        return !(this.engine == null ? other.engine != null : !this.engine.equals(other.engine));
    }

    @Override
    public String toString() {
        return "AbstractProgram [engine=" + this.engine + "]";
    }
}

