/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.DefaultPrologIndicator;
import io.github.prolobjectlink.prolog.ListExpectedError;
import io.github.prolobjectlink.prolog.PrologClause;
import io.github.prolobjectlink.prolog.PrologConverter;
import io.github.prolobjectlink.prolog.PrologDouble;
import io.github.prolobjectlink.prolog.PrologEngine;
import io.github.prolobjectlink.prolog.PrologFloat;
import io.github.prolobjectlink.prolog.PrologIndicator;
import io.github.prolobjectlink.prolog.PrologInteger;
import io.github.prolobjectlink.prolog.PrologJavaConverter;
import io.github.prolobjectlink.prolog.PrologList;
import io.github.prolobjectlink.prolog.PrologLong;
import io.github.prolobjectlink.prolog.PrologParser;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologStructure;
import io.github.prolobjectlink.prolog.PrologTerm;
import io.github.prolobjectlink.prolog.StructureExpectedError;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractProvider
implements PrologProvider {
    protected final PrologConverter<?> converter;
    private static final Set<PrologIndicator> ISO_IEC_BUILT_INS = new HashSet<PrologIndicator>();

    public AbstractProvider(PrologConverter<?> converter) {
        this.converter = converter;
    }

    protected final String removeQuoted(String functor) {
        if (functor != null && functor.startsWith("'") && functor.endsWith("'")) {
            return functor.substring(1, functor.length() - 1);
        }
        return functor;
    }

    @Override
    public final boolean isCompliant() {
        PrologEngine engine = this.newEngine();
        Set<PrologIndicator> implemented = engine.getBuiltIns();
        for (PrologIndicator prologIndicator : ISO_IEC_BUILT_INS) {
            if (!implemented.contains(prologIndicator)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final PrologList parseList(String stringList) {
        PrologTerm term = this.parseTerm(stringList);
        this.checkListType(term);
        return (PrologList)term;
    }

    @Override
    public final PrologClause parseClause(String stringClause) {
        PrologEngine engine = this.newEngine();
        engine.asserta(stringClause);
        return (PrologClause)engine.iterator().next();
    }

    @Override
    public final PrologStructure parseStructure(String stringStructure) {
        PrologTerm term = this.parseTerm(stringStructure);
        this.checkStructureType(term);
        return (PrologStructure)term;
    }

    @Override
    public final Set<PrologClause> parseProgram(String file) {
        return this.newEngine(file).getProgramClauses();
    }

    @Override
    public final Set<PrologClause> parseProgram(File in) {
        return this.parseProgram(in.getAbsolutePath());
    }

    @Override
    public final PrologFloat newFloat() {
        return this.newFloat(Float.valueOf(0.0f));
    }

    @Override
    public final PrologDouble newDouble() {
        return this.newDouble(0.0);
    }

    @Override
    public final PrologInteger newInteger() {
        return this.newInteger(0);
    }

    @Override
    public final PrologLong newLong() {
        return this.newLong(0L);
    }

    @Override
    public final PrologList newList(PrologTerm head) {
        return this.newList(new PrologTerm[]{head});
    }

    @Override
    public final PrologList newList(Object head) {
        return this.newList(this.getJavaConverter().toTerm(head));
    }

    @Override
    public final PrologList newList(Object[] arguments) {
        return this.newList(this.getJavaConverter().toTermsArray(arguments));
    }

    @Override
    public final PrologList newList(Object head, Object tail) {
        PrologJavaConverter transformer = this.getJavaConverter();
        PrologTerm headTerm = transformer.toTerm(head);
        PrologTerm tailTerm = transformer.toTerm(tail);
        return this.newList(headTerm, tailTerm);
    }

    @Override
    public final PrologList newList(Object[] arguments, Object tail) {
        PrologJavaConverter transformer = this.getJavaConverter();
        PrologTerm[] array = transformer.toTermsArray(arguments);
        PrologTerm tailTerm = transformer.toTerm(tail);
        return this.newList(array, tailTerm);
    }

    @Override
    public final PrologTerm newStructure(String functor, Object ... arguments) {
        PrologJavaConverter transformer = this.getJavaConverter();
        PrologTerm[] parameters = transformer.toTermsArray(arguments);
        return this.newStructure(functor, parameters);
    }

    @Override
    public final PrologTerm newStructure(Object left, String operator, Object right) {
        PrologJavaConverter transformer = this.getJavaConverter();
        PrologTerm leftTerm = transformer.toTerm(left);
        PrologTerm rightTerm = transformer.toTerm(right);
        return this.newStructure(leftTerm, operator, rightTerm);
    }

    protected final <T extends PrologTerm> T cast(PrologTerm term, Class<T> type) {
        return (T)((PrologTerm)type.cast(term));
    }

    @Override
    public final <T extends PrologTerm> T cast(PrologTerm term) {
        return (T)term;
    }

    @Override
    public final <K extends PrologTerm> K toTerm(Object o, Class<K> from) {
        return this.converter.toTerm(o, from);
    }

    @Override
    public final <K extends PrologTerm> K[] toTermArray(Object[] os, Class<K[]> from) {
        return this.converter.toTermArray(os, from);
    }

    @Override
    public final <K extends PrologTerm> K[][] toTermMatrix(Object[][] oss, Class<K[][]> from) {
        return this.converter.toTermMatrix(oss, from);
    }

    @Override
    public final <K extends PrologTerm, V> Map<String, PrologTerm> toTermMap(Map<String, V> map, Class<K> from) {
        return this.converter.toTermMap(map, from);
    }

    @Override
    public final <K extends PrologTerm, V> Map<String, PrologTerm>[] toTermMapArray(Map<String, V>[] map, Class<K> from) {
        return this.converter.toTermMapArray(map, from);
    }

    public final PrologConverter<?> getConverter() {
        return this.converter;
    }

    @Override
    public final <K> K fromTerm(PrologTerm term, Class<K> to) {
        return this.converter.fromTerm(term, to);
    }

    @Override
    public final <K> K[] fromTermArray(PrologTerm[] terms, Class<K[]> to) {
        return this.converter.fromTermArray(terms, to);
    }

    @Override
    public final <K> K fromTerm(PrologTerm head, PrologTerm[] body, Class<K> to) {
        return this.converter.fromTerm(head, body, to);
    }

    @Override
    public final PrologParser getParser() {
        return this;
    }

    @Override
    public final String getVersion() {
        return this.newEngine().getVersion();
    }

    @Override
    public final String getName() {
        return this.newEngine().getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.converter == null ? 0 : this.converter.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractProvider other = (AbstractProvider)object;
        return !(this.converter == null ? other.converter != null : !this.converter.equals(other.converter));
    }

    public abstract String toString();

    private final void checkListType(PrologTerm term) {
        if (!term.isList()) {
            throw new ListExpectedError(term);
        }
    }

    private final void checkStructureType(PrologTerm term) {
        if (!term.isStructure()) {
            throw new StructureExpectedError(term);
        }
    }

    static {
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("dynamic", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("include", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("multifile", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("set_prolog_flag", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("ensure_loaded", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("discontiguous", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("current_prolog_flag", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("initialization", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("nil", 0));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("fail", 0));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("true", 0));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("false", 0));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("throw", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("catch", 3));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("=", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("\\=", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("subsume", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("unify_with_occurs_check", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("var", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("atom", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("float", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("number", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("nonvar", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("object", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("ground", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("atomic", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("integer", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("compound", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("callable", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("cyclic_term", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("acyclic_term", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("@>", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("@<", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("==", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("@>=", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("@=<", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("\\==", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("sort", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("compare", 3));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("keysort", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("arg", 3));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("functor", 3));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("copy_term", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("term_variables", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("is", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator(">", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("<", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("=<", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator(">=", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("=:=", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("=\\=", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("clause", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("current_predicate", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("abolish", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("asserta", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("assertz", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("retract", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("forall", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("bagof", 3));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("setof", 3));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("findall", 3));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("open", 3));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("close", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("open", 4));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("close", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("set_input", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("set_output", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("current_input", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("current_output", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("nl", 0));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("read", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("write", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("call", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("once", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("repeat", 0));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("sub_atom", 5));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("char_code", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("atom_chars", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("atom_codes", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("atom_length", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("atom_concat", 3));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("number_chars", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("number_codes", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("op", 3));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("halt", 0));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("halt", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("current_op", 3));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("char_conversion", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("current_char_conversion", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("abs", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("exp", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("log", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("sqrt", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("cbrt", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("floor", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("round", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("ceiling", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("truncate", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("float_integer_part", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("float_fractional_part", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("max", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("min", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("gcd", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("lcm", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("\\//", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("><", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("/\\", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("<<", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator(">>", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("\\/", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("//", 2));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("sin", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("cos", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("tan", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("asin", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("acos", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("atan", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("sign", 1));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("e", 0));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("pi", 0));
        ISO_IEC_BUILT_INS.add(new DefaultPrologIndicator("epsilon", 0));
    }
}

