/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.AbstractEngine;
import io.github.prolobjectlink.prolog.AbstractIterator;
import io.github.prolobjectlink.prolog.PrologEngine;
import io.github.prolobjectlink.prolog.PrologLogger;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologQuery;
import io.github.prolobjectlink.prolog.PrologQueryIterator;
import io.github.prolobjectlink.prolog.PrologTerm;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractQuery
extends AbstractIterator<Collection<PrologTerm>>
implements PrologQuery {
    protected final AbstractEngine engine;

    public AbstractQuery(AbstractEngine engine) {
        this.engine = engine;
    }

    @Override
    public final PrologEngine getEngine() {
        return this.engine;
    }

    @Override
    public final PrologProvider getProvider() {
        return this.engine.getProvider();
    }

    protected final <K extends PrologTerm> K toTerm(Object o, Class<K> from) {
        return this.engine.toTerm(o, from);
    }

    protected final <K extends PrologTerm, V> Map<String, PrologTerm>[] toTermMapArray(Map<String, V>[] map, Class<K> from) {
        return this.engine.toTermMapArray(map, from);
    }

    protected final <K> K fromTerm(PrologTerm term, Class<K> to) {
        return this.engine.fromTerm(term, to);
    }

    protected final boolean contains(List<Map<String, PrologTerm>> maps, Map<String, PrologTerm> map) {
        for (Map<String, PrologTerm> m : maps) {
            if (!m.equals(map)) continue;
            return true;
        }
        return false;
    }

    protected final boolean contains(List<PrologTerm[]> arrays, PrologTerm[] array) {
        for (Object[] objectArray : arrays) {
            if (!Arrays.equals(objectArray, array)) continue;
            return true;
        }
        return false;
    }

    protected final PrologLogger getLogger() {
        return this.getProvider().getLogger();
    }

    @Override
    public final Iterator<Collection<PrologTerm>> iterator() {
        return new PrologQueryIterator(this);
    }

    @Override
    public final boolean hasNext() {
        return this.hasMoreSolutions();
    }

    @Override
    public final Collection<PrologTerm> next() {
        return this.nextVariablesSolution().values();
    }

    @Override
    public final void remove() {
        this.nextSolution();
    }

    @Override
    public final Map<String, PrologTerm> one() {
        return this.oneVariablesSolution();
    }

    @Override
    public final List<Map<String, PrologTerm>> nths(int n) {
        Map<String, PrologTerm>[] maps = this.nVariablesSolutions(n);
        return Arrays.asList(maps);
    }

    @Override
    public final Map<String, PrologTerm> more() {
        return this.nextVariablesSolution();
    }

    @Override
    public final List<Object> oneResult() {
        PrologTerm[] terms = this.oneSolution();
        return this.getProvider().getJavaConverter().toObjectList(terms);
    }

    @Override
    public final List<Object> nextResult() {
        PrologTerm[] terms = this.nextSolution();
        return this.getProvider().getJavaConverter().toObjectList(terms);
    }

    @Override
    public final List<List<Object>> nResult(int n) {
        PrologTerm[][] terms = this.allSolutions();
        return this.getProvider().getJavaConverter().toObjectLists(terms);
    }

    @Override
    public final List<List<Object>> allResults() {
        PrologTerm[][] terms = this.allSolutions();
        return this.getProvider().getJavaConverter().toObjectLists(terms);
    }

    @Override
    public final Map<String, Object> oneVariablesResult() {
        Map<String, PrologTerm> map = this.oneVariablesSolution();
        return this.getProvider().getJavaConverter().toObjectMap(map);
    }

    @Override
    public final Map<String, Object> nextVariablesResult() {
        Map<String, PrologTerm> map = this.nextVariablesSolution();
        return this.getProvider().getJavaConverter().toObjectMap(map);
    }

    @Override
    public final List<Map<String, Object>> nVariablesResults(int n) {
        Map<String, PrologTerm>[] maps = this.nVariablesSolutions(n);
        return this.getProvider().getJavaConverter().toObjectMaps(maps);
    }

    @Override
    public final List<Map<String, Object>> allVariablesResults() {
        Map<String, PrologTerm>[] maps = this.allVariablesSolutions();
        return this.getProvider().getJavaConverter().toObjectMaps(maps);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.engine == null ? 0 : this.engine.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractQuery other = (AbstractQuery)obj;
        return !(this.engine == null ? other.engine != null : !this.engine.equals(other.engine));
    }
}

