/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.PrologError;
import io.github.prolobjectlink.prolog.PrologLogger;
import io.github.prolobjectlink.prolog.PrologNumber;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologTerm;
import io.github.prolobjectlink.prolog.PrologVariable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTerm
implements PrologTerm {
    protected int type;
    protected final PrologProvider provider;

    protected AbstractTerm(int type, PrologProvider provider) {
        this.type = type;
        this.provider = provider;
    }

    protected final void checkIndex(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    protected final void checkIndex(int index, int max) {
        if (index < 0 || index > max) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    protected final String removeQuoted(String functor) {
        if (functor != null && functor.startsWith("'") && functor.endsWith("'")) {
            return functor.substring(1, functor.length() - 1);
        }
        return functor;
    }

    protected final <K extends PrologTerm> K toTerm(Object o, Class<K> from) {
        return this.provider.toTerm(o, from);
    }

    protected final <K extends PrologTerm> K[] toTermArray(Object[] os, Class<K[]> from) {
        return this.provider.toTermArray(os, from);
    }

    protected final <K> K fromTerm(PrologTerm term, Class<K> to) {
        return this.provider.fromTerm(term, to);
    }

    protected final <K> K[] fromTermArray(PrologTerm[] terms, Class<K[]> to) {
        return this.provider.fromTermArray(terms, to);
    }

    protected final PrologLogger getLogger() {
        return this.provider.getLogger();
    }

    @Override
    public PrologTerm getArgument(int index) {
        PrologTerm[] array = this.getArguments();
        this.checkIndex(index, array.length);
        return array[index];
    }

    @Override
    public final String getIndicator() {
        return this.getFunctor() + "/" + this.getArity();
    }

    @Override
    public final boolean hasIndicator(String functor, int arity) {
        return this.getFunctor().equals(functor) && this.getArity() == arity;
    }

    @Override
    public PrologTerm getTerm() {
        return this;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    @Override
    public final PrologProvider getProvider() {
        return this.provider;
    }

    protected final <T extends PrologTerm> T cast(PrologTerm term, Class<T> type) {
        return (T)((PrologTerm)type.cast(term));
    }

    protected final <T extends PrologTerm> T cast(PrologTerm term) {
        return (T)term;
    }

    @Override
    public final <T extends PrologTerm> T cast() {
        return this.cast(this);
    }

    @Override
    public Object getObject() {
        AbstractTerm term = this;
        switch (term.getType()) {
            case 769: {
                return null;
            }
            case 772: {
                return "!";
            }
            case 773: {
                return "fail";
            }
            case 771: {
                return true;
            }
            case 770: {
                return false;
            }
            case 768: {
                return term.getFunctor();
            }
            case 514: {
                return Float.valueOf(((PrologNumber)((Object)term)).getFloatValue());
            }
            case 512: {
                return ((PrologNumber)((Object)term)).getIntegerValue();
            }
            case 515: {
                return ((PrologNumber)((Object)term)).getDoubleValue();
            }
            case 513: {
                return ((PrologNumber)((Object)term)).getLongValue();
            }
            case 256: {
                return ((PrologVariable)((Object)term)).getName();
            }
            case 1281: {
                return this.fromTermArray(term.getArguments(), Object[].class);
            }
            case 1282: {
                return term;
            }
            case 1024: {
                return term.getObject();
            }
            case 1288: {
                PrologVariable field = (PrologVariable)term.cast();
                return "field " + field.getName();
            }
            case 1290: {
                PrologVariable result = (PrologVariable)term.cast();
                return "result " + result.getName();
            }
            case 1291: {
                PrologVariable parameter = (PrologVariable)term.cast();
                return "parameter " + parameter.getName();
            }
            case 1285: 
            case 1286: {
                return "class " + term.getFunctor();
            }
        }
        return null;
    }

    @Override
    public final boolean isEntry() {
        return this.getType() == 1283;
    }

    @Override
    public final boolean isMap() {
        return this.getType() == 1284;
    }

    @Override
    public boolean isField() {
        return this.getType() == 1288;
    }

    @Override
    public boolean isResult() {
        return this.getType() == 1290;
    }

    @Override
    public boolean isParameter() {
        return this.getType() == 1291;
    }

    @Override
    public final boolean isMixin() {
        return this.getType() == 1285;
    }

    @Override
    public final boolean isClass() {
        return this.getType() == 1286;
    }

    @Override
    public boolean isVariableBound() {
        return this.isVariable() && this.getTerm() != this;
    }

    @Override
    public boolean isVariableNotBound() {
        return this.isVariable() && this.getTerm() == this;
    }

    @Override
    public final boolean isClause() {
        return false;
    }

    @Override
    public final boolean isTerm() {
        return true;
    }

    @Override
    public final Map<String, PrologTerm> match(PrologTerm term) {
        ArrayDeque<PrologTerm> stack = new ArrayDeque<PrologTerm>();
        if (this.unify(term, stack)) {
            int size;
            HashMap<String, PrologTerm> substitution = new HashMap<String, PrologTerm>(size);
            for (size = stack.size(); size > 0; --size) {
                PrologVariable variable = (PrologVariable)stack.pop();
                substitution.put(variable.getName(), variable.getTerm());
            }
            return substitution;
        }
        return new HashMap<String, PrologTerm>();
    }

    private boolean unify(PrologTerm term, Deque<PrologTerm> stack) throws PrologError {
        String otherFunctor;
        AbstractTerm thisTerm = this;
        PrologTerm otherTerm = term;
        if (thisTerm.isVariableBound()) {
            return ((AbstractTerm)thisTerm.getTerm()).unify(otherTerm, stack);
        }
        if (otherTerm.isVariableBound()) {
            return ((AbstractTerm)otherTerm.getTerm()).unify(thisTerm, stack);
        }
        if (thisTerm.isVariableNotBound()) {
            stack.push(thisTerm);
            return true;
        }
        if (otherTerm.isVariableNotBound()) {
            stack.push(otherTerm);
            return true;
        }
        if (thisTerm.isNumber() || otherTerm.isNumber()) {
            if ((thisTerm.isInteger() || thisTerm.isLong()) && (otherTerm.isInteger() || otherTerm.isLong())) {
                int otherInt;
                int thisInt = ((PrologNumber)((Object)thisTerm)).getIntegerValue();
                return thisInt == (otherInt = ((PrologNumber)otherTerm).getIntegerValue());
            }
            return thisTerm.equals(otherTerm);
        }
        int thisArity = thisTerm.getArity();
        int otherArity = otherTerm.getArity();
        String thisFunctor = thisTerm.getFunctor();
        if (thisFunctor.equals(otherFunctor = otherTerm.getFunctor()) && thisArity == otherArity) {
            for (int i = 0; i < thisArity; ++i) {
                if (thisTerm.getArgument(i) == null || otherTerm.getArgument(i) == null || ((AbstractTerm)thisTerm.getArgument(i)).unify(otherTerm.getArgument(i), stack)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

