/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.AbstractBuilder;
import io.github.prolobjectlink.prolog.PrologClauseBuilder;
import io.github.prolobjectlink.prolog.PrologEngine;
import io.github.prolobjectlink.prolog.PrologTerm;

final class DefaultClauseBuilder
extends AbstractBuilder
implements PrologClauseBuilder {
    DefaultClauseBuilder(PrologEngine engine) {
        super(engine);
    }

    @Override
    public PrologClauseBuilder begin(PrologTerm term) {
        this.append(Character.valueOf(' '));
        this.append(term);
        return this;
    }

    @Override
    public PrologClauseBuilder begin(String functor, PrologTerm ... arguments) {
        this.append(functor, arguments);
        return this;
    }

    @Override
    public PrologClauseBuilder neck(PrologTerm body) {
        this.append(Character.valueOf(':'));
        this.append(Character.valueOf('-'));
        this.append(Character.valueOf(' '));
        this.append(body);
        return this;
    }

    @Override
    public PrologClauseBuilder neck(String functor, PrologTerm ... arguments) {
        this.append(Character.valueOf(':'));
        this.append(Character.valueOf('-'));
        this.append(Character.valueOf(' '));
        this.append(functor, arguments);
        return this;
    }

    public PrologClauseBuilder neck(PrologTerm left, String operator, int right) {
        this.append(Character.valueOf(':'));
        this.append(Character.valueOf('-'));
        this.append(Character.valueOf(' '));
        this.append(left, operator, right);
        return this;
    }

    @Override
    public PrologClauseBuilder neck(PrologTerm left, String operator, PrologTerm right) {
        this.append(Character.valueOf(':'));
        this.append(Character.valueOf('-'));
        this.append(Character.valueOf(' '));
        this.append(left, operator, (Object)right);
        return this;
    }

    @Override
    public PrologClauseBuilder comma(PrologTerm body) {
        this.append(Character.valueOf(','));
        this.append(Character.valueOf(' '));
        this.append(body);
        return this;
    }

    @Override
    public PrologClauseBuilder comma(String functor, PrologTerm ... arguments) {
        this.append(Character.valueOf(','));
        this.append(Character.valueOf(' '));
        this.append(functor, arguments);
        return this;
    }

    @Override
    public PrologClauseBuilder comma(PrologTerm left, String operator, PrologTerm right) {
        this.append(Character.valueOf(','));
        this.append(Character.valueOf(' '));
        this.append(left, operator, (Object)right);
        return this;
    }

    @Override
    public String getClauseString() {
        return "" + this.builder + "";
    }

    @Override
    public boolean clause() {
        String c = this.getClauseString();
        this.builder = new StringBuilder();
        return this.engine.clause(c);
    }

    @Override
    public void asserta() {
        String c = this.getClauseString();
        this.builder = new StringBuilder();
        this.engine.asserta(c);
    }

    @Override
    public void assertz() {
        String c = this.getClauseString();
        this.builder = new StringBuilder();
        this.engine.assertz(c);
    }

    @Override
    public void retract() {
        String c = this.getClauseString();
        this.builder = new StringBuilder();
        this.engine.retract(c);
    }
}

