/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.AbstractBuilder;
import io.github.prolobjectlink.prolog.PrologEngine;
import io.github.prolobjectlink.prolog.PrologQuery;
import io.github.prolobjectlink.prolog.PrologQueryBuilder;
import io.github.prolobjectlink.prolog.PrologTerm;

final class DefaultQueryBuilder
extends AbstractBuilder
implements PrologQueryBuilder {
    DefaultQueryBuilder(PrologEngine engine) {
        super(engine);
    }

    @Override
    public PrologQueryBuilder begin(String functor, PrologTerm ... arguments) {
        this.append(functor, arguments);
        return this;
    }

    @Override
    public PrologQueryBuilder begin(PrologTerm term) {
        this.append(term);
        return this;
    }

    @Override
    public PrologQueryBuilder comma(PrologTerm body) {
        this.append(Character.valueOf(','));
        this.append(Character.valueOf(' '));
        this.append(body);
        return this;
    }

    @Override
    public PrologQueryBuilder comma(String functor, PrologTerm ... arguments) {
        this.append(Character.valueOf(','));
        this.append(Character.valueOf(' '));
        this.append(functor, arguments);
        return this;
    }

    @Override
    public PrologQueryBuilder comma(PrologTerm left, String operator, PrologTerm right) {
        this.append(Character.valueOf(','));
        this.append(Character.valueOf(' '));
        this.append(left, operator, (Object)right);
        return this;
    }

    @Override
    public PrologQueryBuilder semicolon(PrologTerm term) {
        this.append(Character.valueOf(';'));
        this.append(Character.valueOf(' '));
        this.append(term);
        return this;
    }

    @Override
    public PrologQueryBuilder semicolon(String functor, PrologTerm ... arguments) {
        this.append(Character.valueOf(';'));
        this.append(Character.valueOf(' '));
        this.append(functor, arguments);
        return this;
    }

    @Override
    public PrologQueryBuilder semicolon(PrologTerm left, String operator, PrologTerm right) {
        this.append(Character.valueOf(';'));
        this.append(Character.valueOf(' '));
        this.append(left, operator, (Object)right);
        return this;
    }

    @Override
    public PrologQuery query() {
        String q = "" + this.builder + "";
        this.builder = new StringBuilder();
        return this.engine.query(q);
    }

    @Override
    public String getQueryString() {
        return "" + this.builder + "";
    }
}

