/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologScriptEngine;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public final class Prolog {
    private Prolog() {
    }

    public static PrologProvider getProvider() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("prolog");
        return ((PrologScriptEngine)engine).getProvider();
    }

    public static PrologProvider getProvider(String className) {
        PrologProvider provider = null;
        try {
            return Prolog.getProvider(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            Logger.getLogger(Prolog.class.getName()).log(Level.FINEST, null, e);
            return provider;
        }
    }

    public static PrologProvider getProvider(Class<?> providerClass) {
        PrologProvider provider = null;
        try {
            Constructor<?> constructor = providerClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            provider = (PrologProvider)providerClass.newInstance();
            constructor.setAccessible(false);
        }
        catch (InstantiationException e) {
            Logger.getLogger(Prolog.class.getName()).log(Level.FINEST, null, e);
        }
        catch (IllegalAccessException e) {
            Logger.getLogger(Prolog.class.getName()).log(Level.FINEST, null, e);
        }
        catch (NoSuchMethodException e) {
            Logger.getLogger(Prolog.class.getName()).log(Level.FINEST, null, e);
        }
        catch (SecurityException e) {
            Logger.getLogger(Prolog.class.getName()).log(Level.FINEST, null, e);
        }
        return provider;
    }
}

