/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.PrologClause;
import io.github.prolobjectlink.prolog.PrologClauseBuilder;
import io.github.prolobjectlink.prolog.PrologIndicator;
import io.github.prolobjectlink.prolog.PrologLogger;
import io.github.prolobjectlink.prolog.PrologOperator;
import io.github.prolobjectlink.prolog.PrologProgram;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologQuery;
import io.github.prolobjectlink.prolog.PrologQueryBuilder;
import io.github.prolobjectlink.prolog.PrologTerm;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface PrologEngine
extends Iterable<PrologClause> {
    public boolean runOnWindows();

    public boolean runOnLinux();

    public boolean runOnOSX();

    public String getOSName();

    public String getOSVersion();

    public String getOSArch();

    public List<String> verify();

    public void consult(String var1);

    public void consult(Reader var1);

    public void include(String var1);

    public void include(Reader var1);

    public void persist(String var1);

    public void persist(Writer var1);

    public void abolish(String var1, int var2);

    public void asserta(String var1);

    public void asserta(PrologTerm var1);

    public void asserta(PrologTerm var1, PrologTerm ... var2);

    public void assertz(String var1);

    public void assertz(PrologTerm var1);

    public void assertz(PrologTerm var1, PrologTerm ... var2);

    public boolean clause(String var1);

    public boolean clause(PrologTerm var1);

    public boolean clause(PrologTerm var1, PrologTerm ... var2);

    public void retract(String var1);

    public void retract(PrologTerm var1);

    public void retract(PrologTerm var1, PrologTerm ... var2);

    public boolean unify(PrologTerm var1, PrologTerm var2);

    public boolean contains(String var1);

    public boolean contains(PrologTerm var1);

    public boolean contains(PrologTerm var1, PrologTerm ... var2);

    public PrologQuery query(String var1);

    public PrologQuery query(PrologTerm var1);

    public PrologQuery query(PrologTerm[] var1);

    public PrologQuery query(PrologTerm var1, PrologTerm ... var2);

    public Map<String, PrologTerm> queryOne(String var1);

    public Map<String, PrologTerm> queryOne(PrologTerm var1);

    public Map<String, PrologTerm> queryOne(PrologTerm var1, PrologTerm ... var2);

    public List<Map<String, PrologTerm>> queryN(int var1, String var2);

    public List<Map<String, PrologTerm>> queryN(int var1, PrologTerm var2);

    public List<Map<String, PrologTerm>> queryN(int var1, PrologTerm var2, PrologTerm ... var3);

    public List<Map<String, PrologTerm>> queryAll(String var1);

    public List<Map<String, PrologTerm>> queryAll(PrologTerm var1);

    public List<Map<String, PrologTerm>> queryAll(PrologTerm var1, PrologTerm ... var2);

    public PrologClauseBuilder newClauseBuilder();

    public PrologQueryBuilder newQueryBuilder();

    public void operator(int var1, String var2, String var3);

    public boolean currentPredicate(String var1, int var2);

    public boolean currentOperator(int var1, String var2, String var3);

    public Set<PrologIndicator> currentPredicates();

    public Set<PrologOperator> currentOperators();

    public Map<String, List<PrologClause>> getProgramMap();

    public Set<PrologClause> getProgramClauses();

    public PrologProgram getProgram();

    public int getProgramSize();

    public boolean isProgramEmpty();

    public Set<PrologIndicator> getPredicates();

    public Set<PrologIndicator> getBuiltIns();

    public PrologProvider getProvider();

    public PrologLogger getLogger();

    public String getLicense();

    public String getVersion();

    public String getVendor();

    public String getName();

    public void dispose();
}

