/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.PrologEngine;
import io.github.prolobjectlink.prolog.PrologProvider;
import io.github.prolobjectlink.prolog.PrologQuery;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public final class PrologScriptEngine
extends AbstractScriptEngine
implements ScriptEngine {
    private final PrologEngine prolog;
    private final ScriptEngineFactory factory;

    PrologScriptEngine(ScriptEngineFactory factory, PrologEngine prolog) {
        this.factory = factory;
        this.prolog = prolog;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval(script, context.getBindings(100));
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.eval(reader, context.getBindings(100));
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        BufferedReader bfr = new BufferedReader(reader);
        StringBuilder script = new StringBuilder();
        try {
            String line = bfr.readLine();
            while (line != null) {
                script.append(line);
                script.append("\n");
                line = bfr.readLine();
            }
        }
        catch (IOException ex) {
            throw new ScriptException(ex);
        }
        return this.eval("" + script + "", bindings);
    }

    @Override
    public Object eval(String script, Bindings bindings) throws ScriptException {
        String code = script;
        if (code.startsWith("?-")) {
            PrologQuery query;
            for (Map.Entry entry : bindings.entrySet()) {
                code = code.replace((CharSequence)entry.getKey(), "" + entry.getValue() + "");
            }
            if ((code = code.substring(2).trim()).endsWith(".")) {
                code = code.substring(0, code.length() - 1);
            }
            if (!(query = this.prolog.query(code)).hasSolution()) {
                return false;
            }
            Map<String, Object> map = query.oneVariablesResult();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.prolog.include(new StringReader(code));
        }
        return true;
    }

    @Override
    public Object eval(String string) throws ScriptException {
        return this.eval(string, this.getContext());
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.getContext());
    }

    public PrologProvider getProvider() {
        return this.prolog.getProvider();
    }
}

