/*
 * Decompiled with CFR 0.152.
 */
package io.github.prolobjectlink.prolog;

import io.github.prolobjectlink.prolog.ArrayIterator;
import io.github.prolobjectlink.prolog.PrologEngine;
import io.github.prolobjectlink.prolog.PrologScriptEngine;
import java.util.Arrays;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

public abstract class PrologScriptEngineFactory
implements ScriptEngineFactory {
    private final PrologEngine engine;

    public PrologScriptEngineFactory(PrologEngine engine) {
        this.engine = engine;
    }

    @Override
    public final String getEngineName() {
        return this.engine.getName();
    }

    @Override
    public final String getEngineVersion() {
        return this.engine.getVersion();
    }

    @Override
    public final List<String> getExtensions() {
        return Arrays.asList("pro", "pl");
    }

    @Override
    public final List<String> getMimeTypes() {
        return Arrays.asList("text/plain");
    }

    @Override
    public final List<String> getNames() {
        return Arrays.asList(this.getEngineName(), "Prolog", "prolog");
    }

    @Override
    public final String getLanguageName() {
        return "Prolog";
    }

    @Override
    public final String getLanguageVersion() {
        return this.engine.getVersion();
    }

    @Override
    public final Object getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("javax.script.name")) {
            return this.getEngineName();
        }
        return null;
    }

    @Override
    public final String getOutputStatement(String toDisplay) {
        return "write('" + toDisplay + "')";
    }

    @Override
    public final String getProgram(String ... statements) {
        StringBuilder b = new StringBuilder();
        ArrayIterator<String> i = new ArrayIterator<String>(statements);
        if (i.hasNext()) {
            while (i.hasNext()) {
                b.append((String)i.next());
                if (!i.hasNext()) continue;
                b.append(".\n");
            }
            b.append('.');
        }
        return "" + b + "";
    }

    @Override
    public final ScriptEngine getScriptEngine() {
        return new PrologScriptEngine(this, this.engine);
    }

    public String toString() {
        return "PrologScriptEngineFactory [engine=" + this.engine + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.engine == null ? 0 : this.engine.getName().hashCode());
        result = 31 * result + (this.engine == null ? 0 : this.engine.getVersion().hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PrologScriptEngineFactory other = (PrologScriptEngineFactory)object;
        if (this.engine == null) {
            if (other.engine != null) {
                return false;
            }
        } else {
            if (!this.engine.getName().equals(other.engine.getName())) {
                return false;
            }
            if (!this.engine.getVersion().equals(other.engine.getVersion())) {
                return false;
            }
        }
        return true;
    }
}

