/*
 * Decompiled with CFR 0.152.
 */
package coco4j;

import java.time.Duration;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class ExecutorServices {
    private ExecutorServices() {
    }

    public static boolean awaitTerminationInterruptiblyUnchecked(@NonNull ExecutorService executorService, @NonNull Duration timeout) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        try {
            return executorService.awaitTermination(timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CompletionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean awaitTerminationUninterruptiblyUnchecked(@NonNull ExecutorService executorService, @NonNull Duration timeout) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        InterruptedException interrupted = null;
        try {
            boolean terminated;
            long remainingNanos = timeout.toNanos();
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    terminated = executorService.awaitTermination(remainingNanos, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    interrupted = e;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
            if (interrupted != null) {
                throw new CompletionException(interrupted);
            }
            boolean bl = terminated;
            return bl;
        }
        finally {
            if (interrupted != null) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

