/*
 * Decompiled with CFR 0.152.
 */
package coco4j;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class RejectedExecutionHandlers {
    private RejectedExecutionHandlers() {
    }

    @Nonnull
    public static RejectedExecutionHandler blockingResubmitPolicy() {
        return new BlockingResubmitPolicy();
    }

    public static class BlockingResubmitPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(@NonNull Runnable r, @NonNull ThreadPoolExecutor executor) {
            if (r == null) {
                throw new NullPointerException("r is marked non-null but is null");
            }
            if (executor == null) {
                throw new NullPointerException("executor is marked non-null but is null");
            }
            if (executor.isShutdown()) {
                return;
            }
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

