/*
 * Decompiled with CFR 0.152.
 */
package coco4j;

import java.util.concurrent.CompletionException;
import java.util.concurrent.Semaphore;
import lombok.NonNull;

public class Semaphores {
    private Semaphores() {
    }

    public static void acquireInterruptiblyUncheckable(@NonNull Semaphore semaphore) {
        if (semaphore == null) {
            throw new NullPointerException("semaphore is marked non-null but is null");
        }
        semaphore.acquire();
    }

    public static void acquireInterruptiblyUnchecked(@NonNull Semaphore semaphore) {
        if (semaphore == null) {
            throw new NullPointerException("semaphore is marked non-null but is null");
        }
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CompletionException(e);
        }
    }
}

